<?php
namespace App\Controllers;

use App\Controllers\ApiResourceController;
use App\Models\Setting;

class SettingController extends ApiResourceController
{ 
    public function __construct($container) {
        parent::__construct($container);
        $this->model = Setting::class;
    }

    public function updateCategory($request, $response, $args) {
        $params = $request->getParams();

        if ($args['category'] === 'store' && !$this->auth->isOwner())
            throw new \Slim\Exception\HttpForbiddenException($request);

        foreach($params as $setting => $val) {
            if (empty($val)) $val = null;
            $this->model::updateOrCreate(['setting' => $setting, 'category' => $args['category']], ['value' => $val]);
        }
        return $response->withStatus(204);
    }
}
