<?php
namespace App\Controllers;

use App\Controllers\ApiResourceController;
use App\Models\Server;
use App\Models\StorePackage;

class ServerController extends ApiResourceController
{
    private $adminColumns = ['token', 'rcon_password', 'rcon_port', 'ban_scope', 'ban_log', 'role_sync', 'role_sync_create', 'poll_interval'];

    public function __construct($container) {
        parent::__construct($container);
        $this->model = Server::class;
        $this->columns = ['token', 'name', 'game', 'address', 'port', 'query_port', 'rcon_port', 'rcon_password', 'ban_scope', 'ban_log', 'role_sync','role_sync_create', 'poll_interval', 'image', 'rules', 'order'];
    }

    public function index($request, $response, $args) {
        $data = Server::orderBy('order','asc')->get();

        if ($request->getParam('query')) {
            $data = Server::queryServers($data);
        }

        if ($this->auth->isAdmin())
            $data->map->makeVisible($this->adminColumns);

        return $response->withJSON(['data' => $data->toArray()]);
    }

    public function store($request, $response, $args) {
        $data = $this->model::create($this->columnValues($request));
        $data->makeVisible($this->adminColumns);
        return $response->withJSON(['data' => $data]);
    }

    public function destroy($request, $response, $args) {
        if (StorePackage::where('server', $args['id'])->exists())
            return $response->withJSON(['status' => 'failure', 'message' => 'error_dependent_store_package']);

        $this->cache->forget('api_servers');
        Server::destroy($args['id']);
        return $response->withStatus(204);
    }

    public function reorder($request, $response, $args) {
        foreach ($request->getParam('order') as $id => $order) {
            Server::find($id)->update(['order' => $order]);
        }
        return $response->withStatus(204);
    }

    public function rcon($request, $response, $args) {
        $server = Server::find($args['id']);
        $command = $request->getParam('command');
        if ($command != null && !empty($command)) {
            return $response->withJSON($server->rconCommand($command));
        } else {
            return $response->withStatus(422);
        }
    }
}
