<?php
namespace App\Controllers;

use App\Controllers\Controller;
use App\Models\Role;
use App\Models\RoleSyncExcludedServer;
use App\Models\RolePermission;

class RoleController extends Controller
{
    public function index($request, $response, $args) {
        return $response->withJSON(['data' => Role::getExtended()]);
    }

    public function store($request, $response, $args) {
        $params = $request->getParams();
        $data = Role::create([
            'name' => $params['name'],
            'ingame_equivalent' => $params['ingame_equivalent'] ?? strtolower($params['name']),
            'color' => $params['color'] ?? null,
            'icon' => $params['icon'] ?? null,
            'order' => $params['order'] ?? null
        ]);
        return $response->withJSON(['data' => $data]);
    }

    public function update($request, $response, $args) {
        $params = $request->getParams();
        foreach ($params as &$param) { if ($param === '') { $param = null; } }
        Role::updateOrCreate(['rid' => $args['rid']], [
            'name' => $params['name'],
            'ingame_equivalent' => $params['ingame_equivalent'] ?? strtolower($params['name']),
            'color' => $params['color'] ?? null,
            'icon' => $params['icon'] ?? null,
            'order' => $params['order'] ?? null
        ]);
        return $response->withStatus(204);
    }

    public function destroy($request, $response, $args) {
        Role::destroy($args['rid']);
        return $response->withStatus(204);
    }

    public function reorder($request, $response, $args) {
        $order = $request->getParam('order');
        unset($order[-1]); unset($order[0]); // ignore 'everyone' & 'banned' role order
        foreach ($order as $rid => $order) {
            Role::find($rid)->update(['order' => $order]);
        }
        return $response->withStatus(204);
    }

    public function storeExcludedServer($request, $response, $args) {
        RoleSyncExcludedServer::create([
            'rid' => $args['rid'],
            'server' => $args['server']
        ]);
        return $response->withStatus(204);
    }

    public function destroyExcludedServer($request, $response, $args) {
        RoleSyncExcludedServer::where([
            'rid' => $args['rid'],
            'server' => $args['server']
        ])->delete();
        return $response->withStatus(204);
    }

    public function storePermission($request, $response, $args) {
        $params = $request->getParams();
        RolePermission::create([
            'name' => $params['name'],
            'subject' => $params['subject'],
            'rid' => $params['rid'] ?? null,
            'type' => $params['type']
        ]);
        return $response->withStatus(204);
    }

    public function destroyPermission($request, $response, $args) {
        $params = $request->getParams();
        RolePermission::where([
            'name' => $params['name'],
            'subject' => $params['subject'],
            'rid' => $params['rid'] ?? null
        ])->delete();
        return $response->withStatus(204);
    }
}
