<?php
namespace App\Controllers;

class NotificationController extends Controller
{
    public function index($request, $response, $args) {
        $params = $request->getParams();
        $data = $this->auth->user()->notifications()->orderBy('timestamp', 'DESC')
                                ->paginate($params['perPage'] ?? 20, ['*'], 'page', $params['targetPage'] ?? 1);
        foreach ($data as $notification) {
            if ($notification->type == 'forums_quote' || $notification->type == 'forums_mention')
                $notification->user = $notification->user;
        }
        return $response->withJSON($data);
    }

    public function read($request, $response) {
        $nid = $request->getParam('nid');
        $notifications = $this->auth->user()->notifications();
        if (isset($nid))
            $notifications = $notifications->where('nid', $nid);
        $notifications->update(['read' => 1]);
        return $response->withJSON(['success'=>true]);
    }
}
