<?php
namespace App\Controllers;

use Illuminate\Database\Capsule\Manager as DB;
use Slim\Routing\RouteContext;
use App\Models\Setting;
use App\Helpers;

class MigrationController extends Controller
{
    public function dependencycheck($request, $response) {
        $this->view->getEnvironment()->addGlobal('icons', [
            'success' => '<i class="fas fa-check"></i>',
            'fail' => '<i class="fas fa-times"></i>'
        ]);

        $steamAPIresponse = json_decode(@file_get_contents('https://api.steampowered.com/ISteamWebAPIUtil/GetSupportedAPIList/v0001/?key='.$this->settings['steam_api_key']), true);

        $pdo_mysql_loaded = extension_loaded('pdo_mysql');
        if ($pdo_mysql_loaded) {
            $mysql_credentials = 1;
            $mysql_error = 0;

            try {
                DB::connection()->getPdo();
            } catch (\Exception $e) {
                $mysql_credentials = 0;
                $mysql_error = $e;
            }

            if (!$mysql_error) {
                $ver = DB::select(DB::raw('SELECT version() AS version'))[0]->version;
                if (strpos($ver, '-') !== false) {
                    $ver = substr($ver, 0, strpos($ver, "-"));
                }
                $ver = Helpers::verStrToInt($ver);
                $mysql_version = ($ver >= 50605);
            }
        }

        $requirements = [
            'php_version' => version_compare(PHP_VERSION, '7.3') >= 0,
            'allow_url_fopen' => ini_get('allow_url_fopen'),
            'steam_api_key' => isset($steamAPIresponse['apilist']['interfaces'][35]),
            'curl_extension' => extension_loaded('curl'),
            'xml_extension' => extension_loaded('xml'),
            'pdo_mysql_loaded' => $pdo_mysql_loaded,
            'mysql_credentials' => $mysql_credentials,
            'mysql_version' => $mysql_version ?? 0,
            'mysql_error' => $mysql_error,
            'lock_file_privs' => is_writable(__DIR__.'/..') && is_writable(__DIR__.'/../ember.lock')
        ];

        $somethingFailed = false;
        foreach ($requirements as $key => $value) {
            if ($key != 'mysql_error' && $value == 0 || $key == 'mysql_error' && $value ?? 0 != 0) {
                $somethingFailed = true;
            }
        }

        if (!$somethingFailed) {
            return $response->withRedirect(RouteContext::fromRequest($request)->getRouteParser()->urlFor('migrate'));
        }

        $this->view->getEnvironment()->addGlobal('requirements', $requirements);

        return $this->view->render($response, 'dependencycheck.twig');
    }

    public function migrate($request, $response) {
        if (!file_exists(__DIR__.'/../ember.lock'))
            throw new \Slim\Exception\HttpForbiddenException($request);

        function updateTables($ver, $migrations, $module, $createTables) {
            foreach ($migrations as $migration) {
                if ($ver < Helpers::verStrToInt($migration['version'])) {
                    if (!isset($migration['condition']) || $migration['condition']) { // if the migration has a condition, make sure it evaluates to true
                        if (isset($migration['recreate_tables']) && $migration['recreate_tables'])
                            $createTables();
                        $sql = $migration['sql'] ?? '';
                        $newVer = $migration['version'];
                        break;
                    }
                }
            }

            if (!empty($newVer)) {
                $sql .= 'UPDATE settings SET value="'.$newVer.'" WHERE setting="' . $module . '_version" AND category="updater";';
                DB::unprepared(DB::raw($sql));
                updateTables(Helpers::verStrToInt($newVer), $migrations, $module, $createTables);
            }
        }

        $createTables = function () {
            $sql = file_get_contents(__DIR__ . '/../../database/migrations/schema.sql');
            $sql .= 'INSERT INTO settings SET value="'.CORE_VERSION.'", setting="core_version", category="updater" ON DUPLICATE KEY UPDATE value="'.CORE_VERSION.'";';
            DB::unprepared(DB::raw($sql));
        };

        try { $core_db_version = Setting::where('setting','core_version')->disableCache()->first(); } catch (\Exception $e) {}
        if (isset($core_db_version)) {
            $migrations = require(__DIR__ . '/../../database/migrations/migrations.php');
            updateTables(Helpers::verStrToInt($core_db_version->value), $migrations, 'core', $createTables);
        } else {
            $createTables();
        }

        foreach($this->container->modules as $module) {
            $migrationsPath = __DIR__ . "/../../modules/{$module['identifier']}/database/migrations";
            if(file_exists("$migrationsPath/schema.sql")) {
                $createTables = function () use ($module, $migrationsPath) {
                    $sql = file_get_contents("$migrationsPath/schema.sql");
                    $sql .= 'INSERT INTO settings SET value="' . $module['version'] . '", setting="' . $module['identifier'] . '_version", category="updater";';
                    DB::unprepared(DB::raw($sql));
                };
                try { $moduleDbVersion = Setting::where('setting', "{$module['identifier']}_version")->disableCache()->first(); } catch (\Exception $e) {}
                if (isset($moduleDbVersion)) {
                    if (file_exists("$migrationsPath/migrations.php")) {
                        $migrations = include("$migrationsPath/migrations.php");
                        updateTables(Helpers::verStrToInt($moduleDbVersion->value), $migrations, $module['identifier'], $createTables);
                    }
                } else {
                    $createTables();
                }
            }
        }

        $this->container->cache->flush();
        unlink(__DIR__.'/../ember.lock');
        Helpers::removeRecursively(__DIR__ . '/../../cache/twig');
        return $response->withRedirect(RouteContext::fromRequest($request)->getRouteParser()->urlFor('landing'));
    }
}
