<?php
namespace App\Controllers;

use \Slim\Views\Twig as View;
use Illuminate\Database\Capsule\Manager as DB;
use App\Helpers;
use App\Models\User;
use App\Models\StaffMember;
use App\Models\Setting;
use App\Models\Server;
use App\Models\LoadingScreen;
use App\Models\StoreCredit;
use App\Models\StorePayment;

class AdminController extends Controller
{
    public function store($request, $response) {
        $this->view->getEnvironment()->addGlobal('settings', Setting::getByCategory('store')->toJson(JSON_FORCE_OBJECT));

        $currency_options = ['AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AUD', 'AWG', 'AZN', 'BAM', 'BBD', 'BDT', 'BGN', 'BIF', 'BMD', 'BND', 'BOB', 'BRL', 'BSD', 'BWP', 'BZD', 'CAD', 'CDF', 'CHF', 'CLP', 'CNY', 'COP', 'CRC', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ETB', 'EUR', 'FJD', 'FKP', 'GBP', 'GEL', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'INR', 'ISK', 'JMD', 'JPY', 'KES', 'KGS', 'KHR', 'KMF', 'KRW', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'STD', 'SZL', 'THB', 'TJS', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX', 'USD', 'UYU', 'UZS', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR', 'ZMW'];
        $this->view->getEnvironment()->addGlobal('currency_options', $currency_options);

        $total_revenue = StorePayment::select(DB::raw('SUM(total)'))->first()['SUM(total)'];
        $this->view->getEnvironment()->addGlobal('total_revenue', $total_revenue);

        $monthly_revenue = StorePayment::select([DB::raw('SUM(total)')])->whereRaw('MONTH(timestamp) = MONTH(CURDATE())')->whereRaw('YEAR(timestamp) = YEAR(CURDATE())')->first()['SUM(total)'];
        $this->view->getEnvironment()->addGlobal('monthly_revenue', $monthly_revenue);

        $weekly_revenue = StorePayment::select([DB::raw('SUM(total)')])->whereRaw('WEEK(timestamp) = WEEK(CURDATE())')->whereRaw('YEAR(timestamp) = YEAR(CURDATE())')->first()['SUM(total)'];
        $this->view->getEnvironment()->addGlobal('weekly_revenue', $weekly_revenue);

        $revenue_graph_data_raw = StorePayment::select([DB::raw('SUM(total)'), DB::raw('MONTH(timestamp)')])->whereRaw('YEAR(timestamp) = YEAR(CURDATE())')->groupBy(DB::raw('MONTH(timestamp)'))->get();

        foreach ($revenue_graph_data_raw as $rgd) {
            $revenue_graph_data[$rgd['MONTH(timestamp)']] = $rgd['SUM(total)'];
        }
        for ($i = 1; $i <= 12; $i++) {
            if (!isset($revenue_graph_data[$i])) {
                $revenue_graph_data[$i] = 0;
            }
        }
        ksort($revenue_graph_data);

        $this->view->getEnvironment()->addGlobal('revenue_graph_data', $revenue_graph_data);
        $this->view->getEnvironment()->addGlobal('payment_processors', $this->store);
        return $this->view->render($response, 'admin/store.twig');
    }

    public function general($request, $response) {
        $modelClasses = array_map(function ($class) {
            $path = explode('\\', $class);
            return end($path);
        }, Helpers::getModelClasses());
        $this->view->getEnvironment()->addGlobal('settings', Setting::getByCategory('general')->toJson(JSON_FORCE_OBJECT));
        $this->view->getEnvironment()->addGlobal('models', $modelClasses);
        $this->view->getEnvironment()->addGlobal('core_version', CORE_VERSION);
        $this->view->getEnvironment()->addGlobal('modules', $this->modules);
        if ($this->auth->isOwner()) {
            ob_start(); phpinfo(); $phpinfo = ob_get_contents(); ob_end_clean();
            $this->view->getEnvironment()->addGlobal('phpinfo', $phpinfo);
        }
        return $this->view->render($response, 'admin/general.twig');
    }

    public function roles($request, $response) {
        $this->view->getEnvironment()->addGlobal('servers', Server::orderBy('order','asc')->get());
        return $this->view->render($response, 'admin/roles.twig');
    }

    public function loadingScreens($request, $response) {
        $this->view->getEnvironment()->addGlobal('loadingscreens', LoadingScreen::get()->toArray());
        return $this->view->render($response, 'admin/loadingscreens.twig');
    }

    public function localization($request, $response) {
        $lang = include __DIR__ . '/../../resources/lang/en.php';
        foreach (glob(__DIR__ . '/../../modules/*/resources/lang/en.php') as $langPath) {
            $lang = array_merge($lang, include $langPath);
        }
        $this->view->getEnvironment()->addGlobal('settings', Setting::getByCategory('localization')->toJson(JSON_FORCE_OBJECT));
        $this->view->getEnvironment()->addGlobal('lang', collect($lang)->toJson());
        return $this->view->render($response, 'admin/localization.twig');
    }

    public function servers($request, $response) {
        return $this->view->render($response, 'admin/servers.twig');
    }

    public function landing($request, $response) {
        $this->view->getEnvironment()->addGlobal('servers', Server::orderBy('order','asc')->get());
        $this->view->getEnvironment()->addGlobal('settings', Setting::getByCategory('landing')->toJson(JSON_FORCE_OBJECT));
        return $this->view->render($response, 'admin/landing.twig');
    }
}
