<?php
namespace BitpayIntegration\Controllers;

use App\Controllers\Controller;
use App\Models\Setting;
use App\Store;

use Slim\Routing\RouteContext;

class BitpayController extends Controller
{
    public function process($request, $response, $args) {
        $settings = Setting::getByCategory('store');
        $params = $request->getParams();
        $total = $request->getAttribute('total');

        $posData = [
            'user_id' => $this->auth->id(),
            'type' => $params['type'],
            'total' => $total
        ];
        
        if ($params['type'] == 'credits') {
            $posData['quantity'] = $params['quantity'];
        } else if ($params['type'] == 'package') {
            $package = $request->getAttribute('package');
            $posData['quantity'] = 1;
            $posData['package_id'] = $package->id;
        }

        $baseUrl = $settings['bitpay_test_mode'] ? 'https://test.bitpay.com' : 'https://bitpay.com';
        $url = "{$baseUrl}/invoices";
      
        $data = json_encode([
            'currency' => $settings['currency'],
            'price' => $total / 100,
            'notificationURL' => str_replace('http://', 'https://', RouteContext::fromRequest($request)->getRouteParser()->fullUrlFor($request->getUri(), 'bitpay_ipn')),
            'redirectURL' => RouteContext::fromRequest($request)->getRouteParser()->fullUrlFor($request->getUri(), 'store_purchases'),
            'posData' => base64_encode(json_encode($posData)),
            'itemDesc' => $params['type'] == 'credits' ? 'Credits' : $package->name,
            'token' => $settings['bitpay_api_token']
        ]);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'x-accept-version: 2.0.0',
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, stripslashes($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = json_decode(curl_exec($ch));
        curl_close($ch);

        return $response->withJSON([
            'status' => !isset($result->error) ? 'success' : 'failure',
            'redirect' => isset($result->data) ? $result->data->url : null
        ]);
    }

    public function ipn($request, $response, $args) {
        $settings = Setting::getByCategory('store');

        if ($request->getParam('status') != 'confirmed' && $request->getParam('status') != 'complete')
            return $response->withStatus(200);

        $id = $request->getParam('id');

        $baseUrl = $settings['bitpay_test_mode'] ? 'https://test.bitpay.com' : 'https://bitpay.com';
        $url = "{$baseUrl}/invoices/{$id}";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'x-accept-version: 2.0.0',
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = json_decode(curl_exec($ch));
        curl_close($ch);
    
        if (isset($result->error) || ($result->data->status != 'confirmed' && $result->data->status != 'complete'))
            return $response->withStatus(200);

        $data = json_decode(base64_decode($result->data->posData));
        Store::handlePayment([
            'processor' => 'bitpay',
            'processor_id' => $id,
            'total' => $result->data->price * 100,
            'currency' => $result->data->currency,
            'type' => $data->type,
            'quantity' => $data->quantity,
            'package_id' => $data->package_id ?? null,
            'user_id' => $data->user_id
        ], $response);

        return $response->withStatus(200);
    }
}
