/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

CREATE TABLE IF NOT EXISTS `bans` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `scope` VARCHAR(50) NULL DEFAULT 'server',
    `server_id` INT(10) NULL DEFAULT NULL,
    `offender_user_id` INT(10) UNSIGNED NOT NULL,
    `created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `expires` TIMESTAMP NULL DEFAULT NULL,
    `reason` VARCHAR(500) DEFAULT NULL,
    `admin_user_id` INT(10) UNSIGNED NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `FK_bans_servers` (`server`),
    CONSTRAINT `FK_bans_servers` FOREIGN KEY (`server`) REFERENCES `servers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `features` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `title` VARCHAR(20) DEFAULT NULL,
    `description` VARCHAR(1000) DEFAULT NULL,
    `icon` VARCHAR(25) DEFAULT NULL,
    `order` INT(10) unsigned DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `loading_screens` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) DEFAULT NULL,
    `background` VARCHAR(350) DEFAULT NULL,
    `profile_cover` VARCHAR(350) DEFAULT NULL,
    `about_us` VARCHAR(500) DEFAULT NULL,
    `rules` VARCHAR(500) DEFAULT NULL,
    `db_host` VARCHAR(30) DEFAULT NULL,
    `db_port` VARCHAR(10) DEFAULT NULL,
    `db_username` VARCHAR(20) DEFAULT NULL,
    `db_password` VARCHAR(50) DEFAULT NULL,
    `db_darkrp_database` VARCHAR(20) DEFAULT NULL,
    `db_pointshop_database` VARCHAR(20) DEFAULT NULL,
    `db_pointshop2_database` VARCHAR(20) DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `navbar_links` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(20) NOT NULL,
    `icon` VARCHAR(25) DEFAULT NULL,
    `url` VARCHAR(300) NULL DEFAULT NULL,
    `nested_links` VARCHAR(3000) NULL DEFAULT NULL,
    `admin_only` TINYINT(4) NULL DEFAULT NULL,
    `order` INT(10) unsigned DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `notifications` (
    `nid` BIGINT(20) unsigned NOT NULL AUTO_INCREMENT,
	`user_id` INT(10) UNSIGNED NOT NULL,
    `type` VARCHAR(50) DEFAULT NULL,
    `json` VARCHAR(1000) DEFAULT NULL,
    `read` TINYINT(4) DEFAULT NULL,
    `timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`nid`),
    INDEX `FK_notifications_users` (`user_id`),
    CONSTRAINT `FK_notifications_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `roles` (
    `rid` INT(10) NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) NOT NULL,
    `ingame_equivalent` VARCHAR(50) NOT NULL,
    `color` VARCHAR(6) NULL DEFAULT NULL,
    `icon` VARCHAR(25) NULL DEFAULT NULL,
    `order` INT(10) UNSIGNED NULL DEFAULT NULL,
    PRIMARY KEY (`rid`),
    UNIQUE INDEX `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `role_permissions` (
    `name` VARCHAR(50) NOT NULL,
    `subject` VARCHAR(50) NOT NULL,
    `rid` INT(10) DEFAULT NULL,
    `type` VARCHAR(50) NOT NULL,
    KEY `FK_role_permissions_roles` (`rid`),
    CONSTRAINT `FK_role_permissions_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `role_sync_excluded_servers` (
    `rid` INT(10) NOT NULL,
    `server` INT(10) NOT NULL,
    KEY `FK_role_sync_excluded_servers_roles` (`rid`),
    KEY `FK_role_sync_excluded_servers_servers` (`server`),
    CONSTRAINT `FK_role_sync_excluded_servers_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `FK_role_sync_excluded_servers_servers` FOREIGN KEY (`server`) REFERENCES `servers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `servers` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `token` VARCHAR(50) NULL DEFAULT NULL,
    `name` VARCHAR(30) NOT NULL,
    `game` VARCHAR(10) NOT NULL,
    `address` VARCHAR(30) NULL DEFAULT NULL,
    `port` MEDIUMINT(9) NULL DEFAULT NULL,
    `query_port` MEDIUMINT(9) NULL DEFAULT NULL,
    `rcon_port` MEDIUMINT(9) NULL DEFAULT NULL,
    `rcon_password` VARCHAR(50) NULL DEFAULT NULL,
    `ban_scope` ENUM('server', 'any', 'none') NOT NULL DEFAULT 'server',
	`ban_log` TINYINT(1) NULL DEFAULT '1',
	`role_sync` ENUM('false', 'true', 'receive', 'send') NOT NULL DEFAULT 'true',
	`role_sync_create` TINYINT(1) NULL DEFAULT '1',
	`poll_interval` SMALLINT(5) NULL DEFAULT '120',
    `image` VARCHAR(350) NULL DEFAULT NULL,
    `rules` VARCHAR(3000) NULL DEFAULT NULL,
    `order` INT(10) UNSIGNED NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `settings` (
    `setting` VARCHAR(50) NOT NULL,
    `category` VARCHAR(50) NOT NULL,
    `value` VARCHAR(15000) DEFAULT NULL,
    PRIMARY KEY (`setting`),
    UNIQUE KEY `setting_category` (`setting`,`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `store_credits` (
	`user_id` INT(10) UNSIGNED NOT NULL,
    `credits` MEDIUMINT(7) DEFAULT '0',
    PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `store_failed_payment_logs` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `processor` VARCHAR(50) NOT NULL,
    `processor_id` VARCHAR(100) NULL DEFAULT NULL,
    `message` VARCHAR(500) NOT NULL,
    `timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `store_packages` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `server` INT(10) NOT NULL,
    `name` VARCHAR(250) DEFAULT NULL,
    `cost_credits` MEDIUMINT(9) NULL DEFAULT NULL,
    `cost_currency` MEDIUMINT(9) NULL DEFAULT NULL,
    `valid_for` SMALLINT(5) UNSIGNED NULL DEFAULT NULL,
    `purchase_limit` SMALLINT(5) UNSIGNED NULL DEFAULT NULL,
    `rid` INT(10) DEFAULT NULL,
    `darkrpmoney` INT(10) DEFAULT NULL,
    `pspoints` INT(10) DEFAULT NULL,
    `ps2points` INT(10) DEFAULT NULL,
    `ps2premiumpoints` INT(10) DEFAULT NULL,
    `perma_weapons` VARCHAR(1000) NULL DEFAULT NULL,
    `lua` VARCHAR(5000) DEFAULT NULL,
    `expiry_lua` VARCHAR(5000) DEFAULT NULL,
    `commands` VARCHAR(500) DEFAULT NULL,
    `expiry_commands` VARCHAR(500) DEFAULT NULL,
    `image` VARCHAR(350) DEFAULT NULL,
    `description` TEXT NULL DEFAULT NULL,
    `short_description` VARCHAR(1000) NULL DEFAULT NULL,
    `order` INT(10) UNSIGNED NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `FK_donation_packages_servers` (`server`),
    KEY `FK_store_packages_roles` (`rid`),
    CONSTRAINT `FK_donation_packages_servers` FOREIGN KEY (`server`) REFERENCES `servers` (`id`) ON UPDATE CASCADE,
    CONSTRAINT `FK_store_packages_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `store_package_purchases` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `package_id` INT(10) DEFAULT NULL,
    `payment_id` INT(10) DEFAULT NULL,
    `package_name` VARCHAR(250) DEFAULT NULL,
	`package_cost_credits` MEDIUMINT(9) DEFAULT NULL,
	`user_id` INT(10) UNSIGNED NOT NULL,
    `redeemed` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
    `expired` TINYINT(3) UNSIGNED NULL DEFAULT NULL,
    `purchase_TIMESTAMP` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `expiry_TIMESTAMP` TIMESTAMP NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
    INDEX `FK_store_package_purchases_store_packages` (`package_id`),
    INDEX `FK_store_package_purchases_store_payments` (`payment_id`),
    CONSTRAINT `FK_store_package_purchases_store_packages` FOREIGN KEY (`package_id`) REFERENCES `store_packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT `FK_store_package_purchases_store_payments` FOREIGN KEY (`payment_id`) REFERENCES `store_payments` (`id`) ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `store_payments` (
    `id` INT(10) NOT NULL AUTO_INCREMENT,
    `processor` VARCHAR(50) NOT NULL,
    `processor_id` VARCHAR(100) NOT NULL,
	`user_id` INT(10) UNSIGNED NOT NULL,
    `currency` VARCHAR(3) NOT NULL,
    `total` INT(10) NOT NULL,
    `timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `team` (
	`user_id` INT(10) UNSIGNED NOT NULL,
    `nameoverride` VARCHAR(50) DEFAULT NULL,
    `server` INT(10) DEFAULT NULL,
    `image` VARCHAR(350) DEFAULT NULL,
    `created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `order` INT UNSIGNED NULL DEFAULT NULL,
    PRIMARY KEY (`user_id`),
    KEY `FK_team_servers` (`server`),
    CONSTRAINT `FK_team_servers` FOREIGN KEY (`server`) REFERENCES `servers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `translations` (
    `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
    `locale` VARCHAR(6) NOT NULL,
    `category` VARCHAR(30) NOT NULL,
    `key` VARCHAR(50) NOT NULL,
    `value` VARCHAR(250) NOT NULL,
    `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `locale_category_key` (`locale`, `category`, `key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `users` (
    `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(50) DEFAULT NULL,
    `steamid` BIGINT(20) NULL DEFAULT NULL,
    `discordid` BIGINT(20) UNSIGNED NULL DEFAULT NULL,
	`minecraft_uuid` VARCHAR(36) NULL DEFAULT NULL,
    `created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `last_online` TIMESTAMP NULL DEFAULT NULL,
    `last_played` TIMESTAMP NULL DEFAULT NULL,
    PRIMARY KEY (`id`),
	UNIQUE INDEX `steamid` (`steamid`),
	UNIQUE INDEX `discordid` (`discordid`),
	UNIQUE INDEX `minecraft_uuid` (`minecraft_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `user_revoked_roles` (
	`user_id` INT(10) UNSIGNED NOT NULL,
    `rid` INT(10) NOT NULL,
	UNIQUE INDEX `user_id_rid` (`user_id`, `rid`),
    INDEX `FK_user_revoked_roles_roles` (`rid`),
    CONSTRAINT `FK_user_revoked_roles_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `FK_user_revoked_roles_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `user_roles` (
	`user_id` INT(10) UNSIGNED NOT NULL,
    `rid` INT(10) NOT NULL,
	UNIQUE INDEX `user_id_rid` (`user_id`, `rid`),
    INDEX `FK__roles` (`rid`),
    CONSTRAINT `FK_user_roles_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
    CONSTRAINT `FK__roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `webhooks` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(50) NULL DEFAULT NULL,
	`model` VARCHAR(50) NULL DEFAULT NULL,
	`event` VARCHAR(10) NULL DEFAULT NULL,
	`condition` VARCHAR(300) NULL DEFAULT NULL,
	`url` VARCHAR(1000) NULL DEFAULT NULL,
	`headers` VARCHAR(1000) NULL DEFAULT NULL,
	`body` VARCHAR(10000) NULL DEFAULT NULL,
	`enabled` TINYINT(1) NULL DEFAULT NULL,
	`order` INT(10) UNSIGNED NULL DEFAULT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
