<?php
use Illuminate\Database\Capsule\Manager as DB;

return [
    [
        'version' => '1.2.9',
        'sql' => "ALTER TABLE `servers`
                    CHANGE COLUMN `address` `address` VARCHAR(30) NOT NULL AFTER `game`,
                    ADD COLUMN `port` MEDIUMINT NOT NULL DEFAULT '27015' AFTER `address`,
                    ADD COLUMN `queryport` MEDIUMINT NOT NULL DEFAULT '27015' AFTER `port`;

                ALTER TABLE `users`
                    ADD COLUMN `name` VARCHAR(50) NULL DEFAULT NULL AFTER `steamid`;

                ALTER TABLE `bans` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `features` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `groups` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `loading_screens` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `navbar_links` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `servers` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `settings` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `store_credits` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `store_packages` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `store_package_purchases` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `store_transactions` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `store_transaction_logs` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `team` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;
                ALTER TABLE `users` COLLATE='utf8mb4_general_ci', CONVERT TO CHARSET utf8mb4;

                ALTER TABLE `store_packages`
                    ADD COLUMN `gid` INT(11) NULL DEFAULT NULL AFTER `cost`,
                    ADD CONSTRAINT `FK_store_packages_groups` FOREIGN KEY (`gid`) REFERENCES `groups` (`gid`) ON UPDATE CASCADE ON DELETE SET NULL;
                ALTER TABLE `store_packages`
                    CHANGE COLUMN `usergroup` `ulx_group` VARCHAR(50) NULL DEFAULT NULL AFTER `gid`;
                ALTER TABLE `bans`
                    DROP FOREIGN KEY `FK_bans_players`,
                    DROP FOREIGN KEY `FK_bans_players_2`;
                DROP TABLE `players`;
                ALTER TABLE `team`
                    DROP COLUMN `title`;"
    ], [
        'version' => '1.3.0',
        'sql' => 'ALTER TABLE `navbar_links`
              	 ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `url`;
                ALTER TABLE `features`
                	ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `icon`;'
    ], [
        'version' => '1.3.1',
        'sql' => "ALTER TABLE `servers`
                	ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `rules`;
                ALTER TABLE `store_packages`
                	ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `description`;
                UPDATE `settings` SET `category`='general' WHERE `setting`='terms';"
    ], [
        'version' => '1.3.2',
        'sql' => 'ALTER TABLE `settings`
              		CHANGE COLUMN `value` `value` VARCHAR(15000) NULL DEFAULT NULL AFTER `category`;'
    ], [
        'version' => '1.3.3',
        'sql' => 'ALTER TABLE `navbar_links`
            	  	ADD COLUMN `admin_only` TINYINT NULL AFTER `url`;
                ALTER TABLE `groups`
              		ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `perms_forum_moderate`;'
    ], [
        'version' => '1.3.4',
        'sql' => "ALTER TABLE `store_packages`
            	  	ADD COLUMN `valid_for` SMALLINT UNSIGNED NULL DEFAULT NULL AFTER `cost`,
               		ADD COLUMN `expiry_lua` VARCHAR(5000) NULL DEFAULT NULL AFTER `lua`,
              		ADD COLUMN `purchase_limit` SMALLINT(5) UNSIGNED NULL DEFAULT NULL AFTER `valid_for`;
                ALTER TABLE `store_package_purchases`
             	  	CHANGE COLUMN `redeemed` `redeemed` TINYINT UNSIGNED NOT NULL DEFAULT '0' AFTER `steamid`,
            	  	ADD COLUMN `expired` TINYINT(3) UNSIGNED NULL DEFAULT NULL AFTER `redeemed`;"
    ], [
        'version' => '1.3.5',
        'sql' => 'ALTER TABLE `store_packages`
            	  	ADD COLUMN `perma_weapons` VARCHAR(1000) NULL DEFAULT NULL AFTER `ps2premiumpoints`;'
    ], [
        'version' => '1.4.1',
        'sql' => 'ALTER TABLE `users`
            	  	ADD COLUMN `discordid` BIGINT UNSIGNED NULL DEFAULT NULL AFTER `gid`;'
    ], [
        'version' => '2.0.0',
        'recreate_tables' => true,
        'sql' => 'ALTER TABLE `servers`
                	ADD COLUMN `token` VARCHAR(50) NULL DEFAULT NULL AFTER `id`,
                	ADD UNIQUE INDEX `token` (`token`);'
    ], [
        'version' => '2.0.5',
        'sql' => 'ALTER TABLE `team`
	                ADD COLUMN `order` INT UNSIGNED NULL DEFAULT NULL AFTER `created`;'
    ], [
        'version' => '2.0.6',
        'sql' => 'ALTER TABLE `groups`
	                ADD COLUMN `color` VARCHAR(6) NULL DEFAULT NULL AFTER `name`;'
    ], [
        'version' => '2.0.8',
        'sql' => 'ALTER TABLE `users`
                	ADD COLUMN `group_sync_revoked` TINYINT NULL DEFAULT NULL AFTER `gid`;
                ALTER TABLE `groups`
                  ADD COLUMN `ingame_equivalent` VARCHAR(50) NULL DEFAULT NULL AFTER `name`;
                ALTER TABLE `groups`
                  ADD UNIQUE INDEX `name` (`name`),
                	ADD UNIQUE INDEX `ingame_equivalent` (`ingame_equivalent`);'
    ], [
        'version' => '2.1.0',
        'sql' => 'ALTER TABLE `store_packages`
                	CHANGE COLUMN `description` `description` TEXT NULL DEFAULT NULL AFTER `image`,
                	ADD COLUMN `short_description` VARCHAR(1000) NULL DEFAULT NULL AFTER `description`;'
    ], [
        'version' => '2.1.8',
        'sql' => 'ALTER TABLE `users`
                	ADD COLUMN `last_online` TIMESTAMP NULL DEFAULT NULL AFTER `created`,
                	CHANGE COLUMN `last_online` `last_played` TIMESTAMP NULL DEFAULT NULL AFTER `last_online`;'
    ], [
        'version' => '2.1.9',
        'recreate_tables' => true,
        'sql' => "/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

                ALTER TABLE `store_packages`
                	DROP FOREIGN KEY `FK_store_packages_groups`;
                ALTER TABLE `store_packages`
                	CHANGE COLUMN `gid` `rid` INT(11) NULL DEFAULT NULL AFTER `purchase_limit`,
                	ADD CONSTRAINT `FK_store_packages_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON UPDATE CASCADE ON DELETE SET NULL;

                ALTER TABLE `bans`
	                 ADD COLUMN `scope` VARCHAR(50) NULL DEFAULT 'server' AFTER `id`;
                UPDATE `bans` SET `scope` = 'global' WHERE `server` IS NULL;

                INSERT INTO `role_permissions` (`name`, `subject`, `rid`, `type`) SELECT 'admin', 'role', `gid`, 'allow' FROM `groups` WHERE `perms_site_admin` = 1;
                INSERT INTO `role_permissions` (`name`, `subject`, `rid`, `type`) SELECT 'manage_bans', 'role', `gid`, 'allow' FROM `groups` WHERE `perms_ban_user` = 1;
                INSERT INTO `role_permissions` (`name`, `subject`, `rid`, `type`) SELECT 'forums_moderate', 'role', `gid`, 'allow' FROM `groups` WHERE `perms_forum_moderate` = 1;

                ALTER TABLE `groups`
                  CHANGE COLUMN `gid` `rid` INT(11) NOT NULL AUTO_INCREMENT FIRST,
                  DROP COLUMN `perms_site_admin`,
                  DROP COLUMN `perms_ban_user`,
                  DROP COLUMN `perms_forum_moderate`;

                DROP TABLE `roles`;
                RENAME TABLE `groups` TO `roles`;

                INSERT INTO `user_roles` (`steamid`, `rid`) SELECT `steamid`, `gid` FROM `users` WHERE `gid` IS NOT NULL;

                ALTER TABLE `users`
                	DROP FOREIGN KEY `FK_users_groups`,
                	DROP COLUMN `gid`,
                  DROP COLUMN `group_sync_revoked`;
                
                ALTER TABLE `store_packages`
                  DROP COLUMN `ulx_group`;

                /*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;" // 171671443
    ], [
        'version' => '2.2.0',
        'condition' => empty(DB::select(DB::raw('SHOW COLUMNS FROM `store_packages` LIKE "rid";'))),
        'sql' => 'ALTER TABLE `store_packages`
                    DROP FOREIGN KEY `FK_store_packages_groups`;
                  ALTER TABLE `store_packages`
                    CHANGE COLUMN `gid` `rid` INT(11) NULL DEFAULT NULL AFTER `purchase_limit`,
                    ADD CONSTRAINT `FK_store_packages_roles` FOREIGN KEY (`rid`) REFERENCES `roles` (`rid`) ON UPDATE CASCADE ON DELETE SET NULL;
                  ALTER TABLE `users`
                    DROP FOREIGN KEY `FK_users_groups`,
                    DROP COLUMN `gid`,
                    DROP COLUMN `group_sync_revoked`;'
    ], [
        'version' => '2.2.2',
        'recreate_tables' => true,
        'sql' => 'ALTER TABLE `roles` DROP INDEX `ingame_equivalent`;'
    ], [
        'version' => '2.2.6',
        'recreate_tables' => true,
        'sql' => "DROP TABLE `store_payments`;
                UPDATE `store_transactions` SET `cost` = `cost` * 100;
                ALTER TABLE `store_transactions`
                  ADD COLUMN `processor` VARCHAR(50) NOT NULL AFTER `id`,
                  CHANGE COLUMN `txn_id` `processor_id` VARCHAR(100) NOT NULL AFTER `processor`,
                  CHANGE COLUMN `steamid` `steamid` BIGINT(20) NOT NULL AFTER `processor_id`,
                  CHANGE COLUMN `currency` `currency` VARCHAR(3) NOT NULL AFTER `steamid`,
                  CHANGE COLUMN `cost` `total` INT(11) NOT NULL AFTER `currency`,
                  DROP COLUMN `name`,
                  DROP COLUMN `email`,
                  DROP COLUMN `credits`;
                RENAME TABLE `store_transactions` TO `store_payments`;
                UPDATE `store_payments` SET `processor` = 'paypal';
                UPDATE `settings` SET `setting` = 'currency' WHERE `setting` = 'paypal_currency';
                DROP TABLE `store_transaction_logs`;"
    ], [
        'version' => '2.2.7',
        'recreate_tables' => true,
        'sql' => 'ALTER TABLE `store_packages`
                  ADD COLUMN `commands` VARCHAR(500) NULL DEFAULT NULL AFTER `expiry_lua`,
                  ADD COLUMN `expiry_commands` VARCHAR(500) NULL DEFAULT NULL AFTER `commands`;'
    ], [
        'version' => '2.2.8',
        'sql' => 'ALTER TABLE `store_packages`
                  CHANGE COLUMN `cost` `cost` MEDIUMINT(9) NULL DEFAULT NULL AFTER `name`;'
    ], [
        'version' => '2.3.0',
        'sql' => 'ALTER TABLE `store_package_purchases`
                  ADD COLUMN `expiry_timestamp` TIMESTAMP NULL DEFAULT NULL AFTER `purchase_timestamp`;
                UPDATE `store_package_purchases` AS `pp` LEFT JOIN `store_packages` AS `p` ON `pp`.`package` = `p`.`id` SET `expiry_timestamp` = DATE_ADD(`pp`.`purchase_timestamp`, INTERVAL `p`.`valid_for` DAY) WHERE `expired` IS NOT NULL AND `expiry_timestamp` IS NULL;'
    ], [
        'version' => '2.3.2',
        'sql' => '/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
                ALTER TABLE `servers`
                  CHANGE COLUMN `id` `id` INT(11) NOT NULL AUTO_INCREMENT FIRST,
                  CHANGE COLUMN `address` `address` VARCHAR(30) NULL DEFAULT NULL AFTER `game`,
                  CHANGE COLUMN `port` `port` MEDIUMINT(9) NULL DEFAULT NULL AFTER `address`,
                  CHANGE COLUMN `queryport` `query_port` MEDIUMINT(9) NULL DEFAULT NULL AFTER `port`,
                  ADD COLUMN `rcon_port` MEDIUMINT(9) NULL DEFAULT NULL AFTER `query_port`,
                  ADD COLUMN `rcon_password` VARCHAR(50) NULL DEFAULT NULL AFTER `rcon_port`;
                /*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;'
    ], [
        'version' => '2.3.5',
        'sql' => 'ALTER TABLE `navbar_links`
                  CHANGE COLUMN `url` `url` VARCHAR(300) NULL DEFAULT NULL AFTER `icon`;'
    ], [
        'version' => '2.4.2',
        'sql' => 'ALTER TABLE `loading_screens`
                ADD COLUMN `about_us` VARCHAR(500) NULL DEFAULT NULL AFTER `profile_cover`,
                ADD COLUMN `db_host` VARCHAR(30) NULL DEFAULT NULL AFTER `rules`,
                ADD COLUMN `db_port` VARCHAR(10) NULL DEFAULT NULL AFTER `db_host`,
                ADD COLUMN `db_username` VARCHAR(20) NULL DEFAULT NULL AFTER `db_port`,
                ADD COLUMN `db_password` VARCHAR(50) NULL DEFAULT NULL AFTER `db_username`,
                ADD COLUMN `db_darkrp_database` VARCHAR(20) NULL DEFAULT NULL AFTER `db_password`,
                ADD COLUMN `db_pointshop_database` VARCHAR(20) NULL DEFAULT NULL AFTER `db_darkrp_database`;'
    ], [
        'version' => '2.4.3',
        'recreate_tables' => true,
        'sql' => 'ALTER TABLE `store_package_purchases`
                DROP INDEX `FK_donation_purchases_donation_credits`,
                DROP FOREIGN KEY `FK_donation_purchases_donation_credits`;'
    ], [
        'version' => '2.4.4',
        'sql' => 'ALTER TABLE `loading_screens`
                ADD COLUMN `db_pointshop2_database` VARCHAR(20) NULL DEFAULT NULL AFTER `db_pointshop_database`;'
    ], [
        'version' => '2.5.0',
        'sql' => 'ALTER TABLE `store_packages`
                    CHANGE COLUMN `cost` `cost_credits` MEDIUMINT(9) NULL DEFAULT NULL AFTER `name`,
                    ADD COLUMN `cost_currency` MEDIUMINT(9) NULL DEFAULT NULL AFTER `cost_credits`;
                ALTER TABLE `store_package_purchases`
                    ADD COLUMN `payment_id` INT(11) NULL DEFAULT NULL AFTER `package`,
                    ADD COLUMN `package_name` VARCHAR(250) NULL DEFAULT NULL AFTER `payment_id`,
                    ADD COLUMN `package_cost_credits` MEDIUMINT(9) NULL DEFAULT NULL AFTER `package_name`,
                    ADD CONSTRAINT `FK_store_package_purchases_store_payments` FOREIGN KEY (`payment_id`) REFERENCES `store_payments` (`id`) ON UPDATE CASCADE ON DELETE SET NULL;
                UPDATE `store_package_purchases` `p`
                    INNER JOIN `store_packages` `pkg` ON `p`.`package` = `pkg`.`id`
                    SET `p`.`package_name` = `pkg`.`name`, `p`.`package_cost_credits` = `pkg`.`cost_credits`;'
    ], [
        'version' => '2.5.2',
        'recreate_tables' => true
    ], [
        'version' => '2.5.3',
        'sql' => 'ALTER TABLE `navbar_links`
            ADD COLUMN `nested_links` VARCHAR(3000) NULL DEFAULT NULL AFTER `url`;'
    ], [
        'version' => '2.6.0',
        'sql' => 'UPDATE `users`
                    INNER JOIN `users` AS `other` ON `users`.`steamid` != `other`.`steamid` AND `users`.`discordid` = `other`.`discordid`
                    SET `users`.`discordid` = NULL;

                ALTER TABLE `users`
                    ADD COLUMN `id` INT UNSIGNED NOT NULL FIRST,
                    CHANGE COLUMN `steamid` `steamid` BIGINT NULL DEFAULT NULL AFTER `name`,
                    ADD COLUMN `minecraft_uuid` VARCHAR(36) NULL DEFAULT NULL AFTER `discordid`,
                    DROP PRIMARY KEY,
                    ADD UNIQUE INDEX `steamid` (`steamid`),
                    ADD UNIQUE INDEX `discordid` (`discordid`),
                    ADD UNIQUE INDEX `minecraft_uuid` (`minecraft_uuid`);
                UPDATE `users` SET `id` = 0 - `id`;
                SET @index = 0;
                UPDATE `users` SET `id` = (@index := @index + 1) ORDER BY `created` ASC;
                ALTER TABLE `users`
                    ADD PRIMARY KEY (`id`),
                    CHANGE COLUMN `id` `id` INT UNSIGNED NOT NULL AUTO_INCREMENT FIRST;

                ALTER TABLE `bans`
                    ADD COLUMN `offender_user_id` INT UNSIGNED NOT NULL AFTER `server`,
                    ADD COLUMN `admin_user_id` INT UNSIGNED NULL DEFAULT NULL AFTER `reason`;
                INSERT IGNORE INTO `users` (`steamid`) SELECT DISTINCT `offender_steamid` FROM `bans`;
                UPDATE `bans`
                    INNER JOIN `users` AS `offenders` ON `bans`.`offender_steamid` = `offenders`.`steamid`
                    LEFT JOIN `users` AS `admins` ON `bans`.`admin_steamid` = `admins`.`steamid`
                    SET `bans`.`offender_user_id` = `offenders`.`id`, `bans`.`admin_user_id` = `admins`.`id`;
                ALTER TABLE `bans`
                    DROP COLUMN `offender_steamid`,
                    DROP COLUMN `admin_steamid`;
                ALTER TABLE `bans`
                    CHANGE COLUMN `server` `server_id` INT NULL DEFAULT NULL AFTER `scope`,
                    DROP INDEX `FK_bans_servers`,
                    ADD INDEX `FK_bans_servers` (`server_id`);

                ALTER TABLE `notifications`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `nid`,
                    DROP FOREIGN KEY `FK_notifications_users`;
                UPDATE `notifications`
                    INNER JOIN `users` ON `notifications`.`steamid` = `users`.`steamid`
                    SET `notifications`.`user_id` = `users`.`id`;
                ALTER TABLE `notifications`
                    DROP COLUMN `steamid`,
                    ADD CONSTRAINT `FK_notifications_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `store_credits`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL FIRST,
                    DROP PRIMARY KEY;
                UPDATE `store_credits`
                    INNER JOIN `users` ON `store_credits`.`steamid` = `users`.`steamid`
                    SET `store_credits`.`user_id` = `users`.`id`;
                ALTER TABLE `store_credits`
                    DROP COLUMN `steamid`,
                    ADD PRIMARY KEY (`user_id`);

                ALTER TABLE `store_package_purchases`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `package_cost_credits`;
                UPDATE `store_package_purchases`
                    INNER JOIN `users` ON `store_package_purchases`.`steamid` = `users`.`steamid`
                    SET `store_package_purchases`.`user_id` = `users`.`id`;
                ALTER TABLE `store_package_purchases`
                    DROP COLUMN `steamid`;

                ALTER TABLE `store_payments`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL AFTER `processor_id`;
                UPDATE `store_payments`
                    INNER JOIN `users` ON `store_payments`.`steamid` = `users`.`steamid`
                    SET `store_payments`.`user_id` = `users`.`id`;
                ALTER TABLE `store_payments`
                    DROP COLUMN `steamid`;

                DELETE FROM `team` WHERE `team`.`steamid` NOT IN (SELECT `steamid` FROM `users`);
                ALTER TABLE `team`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL FIRST,
                    DROP PRIMARY KEY;
                UPDATE `team`
                    INNER JOIN `users` ON `team`.`steamid` = `users`.`steamid`
                    SET `team`.`user_id` = `users`.`id`;
                ALTER TABLE `team`
                    DROP COLUMN `steamid`,
                    ADD PRIMARY KEY (`user_id`),
                    ADD CONSTRAINT `FK_team_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `user_revoked_roles`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL FIRST,
                    DROP INDEX `steamid_rid`,
                    DROP FOREIGN KEY `FK_user_revoked_roles_users`;
                UPDATE `user_revoked_roles`
                    INNER JOIN `users` ON `user_revoked_roles`.`steamid` = `users`.`steamid`
                    SET `user_revoked_roles`.`user_id` = `users`.`id`;
                ALTER TABLE `user_revoked_roles`
                    DROP COLUMN `steamid`,
                    ADD UNIQUE INDEX `user_id_rid` (`user_id`, `rid`),
                    ADD CONSTRAINT `FK_user_revoked_roles_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `user_roles`
                    ADD COLUMN `user_id` INT UNSIGNED NOT NULL FIRST,
                    DROP INDEX `steamid_rid`,
                    DROP FOREIGN KEY `FK__users`;
                UPDATE `user_roles`
                    INNER JOIN `users` ON `user_roles`.`steamid` = `users`.`steamid`
                    SET `user_roles`.`user_id` = `users`.`id`;
                ALTER TABLE `user_roles`
                    DROP COLUMN `steamid`,
                    ADD UNIQUE INDEX `user_id_rid` (`user_id`, `rid`),
                    ADD CONSTRAINT `FK_user_roles_users` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON UPDATE CASCADE ON DELETE CASCADE;

                ALTER TABLE `store_package_purchases`
                    DROP INDEX `FK_donation_purchases_donation_packages`,
                    DROP FOREIGN KEY `FK_donation_purchases_donation_packages`,
                    CHANGE COLUMN `package` `package_id` INT NULL DEFAULT NULL AFTER `id`,
                    ADD INDEX `FK_store_package_purchases_store_packages` (`package_id`),
                    ADD CONSTRAINT `FK_store_package_purchases_store_packages` FOREIGN KEY (`package_id`) REFERENCES `store_packages` (`id`) ON UPDATE CASCADE ON DELETE SET NULL;

                UPDATE `store_packages` SET `commands` = REPLACE(`commands`, \'{ply.\', \'{user.\'), `expiry_commands` = REPLACE(`expiry_commands`, \'{ply.\', \'{user.\');
                
                ALTER TABLE `servers`
                	ADD COLUMN `ban_scope` ENUM(\'server\', \'any\', \'none\') NOT NULL DEFAULT \'server\' AFTER `rcon_password`,
	                ADD COLUMN `ban_log` TINYINT(1) NULL DEFAULT 1 AFTER `ban_scope`,
                    ADD COLUMN `role_sync` ENUM(\'false\', \'true\', \'receive\', \'send\') NOT NULL DEFAULT \'true\' AFTER `ban_scope`,
                    ADD COLUMN `role_sync_create` TINYINT(1) NULL DEFAULT 1 AFTER `role_sync`,
	                ADD COLUMN `poll_interval` SMALLINT NULL DEFAULT \'120\' AFTER `role_sync_create`;'
    ]
];
