<?php
define('CORE_VERSION', '2.6.0');
$loader = require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../config.php';
foreach ([
    'STEAM_API_KEY' => &$settings['steam_api_key'],
    'DISCORD_API_CLIENT_ID' => &$settings['discord_api']['client_id'],
    'DISCORD_API_CLIENT_SECRET' => &$settings['discord_api']['client_secret'],
    'DISCORD_API_BOT_TOKEN' => &$settings['discord_api']['bot_token'],
    'DISCORD_API_GUILD_ID' => &$settings['discord_api']['guild_id'],
    'DB_HOST' => &$settings['db']['host'],
    'DB_PORT' => &$settings['db']['port'],
    'DB_DATABASE' => &$settings['db']['database'],
    'DB_USERNAME' => &$settings['db']['username'],
    'DB_PASSWORD' => &$settings['db']['password'],
    'CACHE_DRIVER' => &$settings['cache']['cache.default'],
    'REDIS_HOST' => &$settings['cache']['database.redis']['default']['host'],
    'REDIS_PASSWORD' => &$settings['cache']['database.redis']['default']['password'],
    'REDIS_PORT' => &$settings['cache']['database.redis']['default']['port'],
    'REDIS_DATABASE' => &$settings['cache']['database.redis']['default']['database'],
    'MEMCACHED_HOST' => &$settings['cache']['cache.stores.memcached']['servers'][0]['host'],
    'MEMCACHED_PORT' => &$settings['cache']['cache.stores.memcached']['servers'][0]['port'],
    'MEMCACHED_WEIGHT' => &$settings['cache']['cache.stores.memcached']['servers'][0]['weight'],
    'SESSION_LIFETIME' => &$settings['session_lifetime'],
    'DEVELOPMENT_MODE' => &$settings['development_mode']
] as $key => &$value) {
    if (getenv($key)) $value = getenv($key);
}

use Illuminate\Container\Container;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Slim\Factory\AppFactory;
use Slim\Views\Twig;
use Slim\Views\TwigMiddleware;
use Slim\Middleware\ContentLengthMiddleware;
use Twig\TwigFilter;

ini_set('session.gc_maxlifetime', $settings['session_lifetime']);
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_samesite', 'Lax');
if(isset($_COOKIE[session_name()])) {
    session_start();
    $session_params = session_get_cookie_params();
    unset($session_params['lifetime']);
    $session_params['expires'] = time() + $settings['session_lifetime'];
    setcookie(session_name(), session_id(), $session_params);
}

if (file_exists(__DIR__.'/../app/ember.lock')) { $settings['development_mode'] = true; }
if ($settings['development_mode']) {
    ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0); ini_set('display_startup_errors', 0);
}

$container = new Container;
Container::setInstance($container); // set the globlly available instance
$container->singleton('response', function($container) {
    return (new \Slim\Http\Factory\DecoratedResponseFactory(new \Http\Factory\Guzzle\ResponseFactory(), new \Http\Factory\Guzzle\StreamFactory()))->createResponse();
});
AppFactory::setContainer($container);
$app = AppFactory::create();
if (!$settings['development_mode']) {
    $app->add(new ContentLengthMiddleware());
}

$settings = array_merge_recursive([
    'db' => [
        'driver' => 'mysql',
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_general_ci',
        'timezone'  => '+00:00',
        'prefix' => '',
        'options' => [
            \PDO::ATTR_EMULATE_PREPARES => true
        ]
    ],
    'cache' => [
        'cache.stores.array' => [
            'driver' => 'array'
        ],
        'cache.stores.file' => [
            'driver' => 'file',
            'path' => __DIR__ . '/../cache'
        ],
        'cache.stores.redis' => [
            'driver' => 'redis',
            'connection' => 'default'
        ],
        'cache.stores.memcached' => [
            'driver' => 'memcached'
        ],
        'cache.prefix' => 'illuminate_non_laravel'
    ],
    'laravel-model-caching.enabled' => true,
    'laravel-model-caching.use-database-keying' => true,
    'laravel-model-caching.cache-prefix' => null,
    'laravel-model-caching.store' => null
], $settings);

$container->singleton('settings', function() use ($settings) {
    return $settings;
});

$dispatcher = new \Illuminate\Events\Dispatcher($container);
$container->instance('dispatcher', $dispatcher);

class_alias(Illuminate\Database\Eloquent\Builder::class, 'GeneaLabs\LaravelModelCaching\EloquentBuilder');
$capsule = new \Illuminate\Database\Capsule\Manager;
$capsule->addConnection($settings['db'], 'default');
$capsule->setEventDispatcher($dispatcher);
$capsule->setAsGlobal();
$capsule->bootEloquent();
$container->instance('capsule', $capsule);
$container->instance('db', $capsule->getConnection());

$container->singleton('config', function($container) use ($settings) {
    class Config extends \Illuminate\Support\Facades\Facade
    {
        private $settings;

        function __construct($settings) {
            $this->settings = $settings;
        }

        function get($key) {
            return $this->settings[$key];
        }
    }

    return new Config($settings);
});

$container->singleton('request', function() {
    class fakeObj { function input() { return null; } }
    return new fakeObj;
});

$container->singleton('cache', function($container) use ($settings) {
    $cacheContainer = new Container;
    $cacheContainer->singleton('config', function($container) use ($settings) {
        return $settings['cache'];
    });
    $cacheContainer->singleton('files', '\Illuminate\Filesystem\Filesystem');
    $cacheContainer->singleton('redis', function ($container) {
        return new \Illuminate\Redis\RedisManager(null, 'predis', $container->get('config')['database.redis']);
    });
    $cacheContainer->bind('memcached.connector', 'Illuminate\Cache\MemcachedConnector');
    $cacheManager = new \Illuminate\Cache\CacheManager($cacheContainer);
    return $cacheManager->driver();
});

function app($str) {
    global $app;
    if ($str == 'container') {
        return $app->getContainer();
    }
}

$container->singleton('auth', '\App\Auth\Auth');

$container->singleton('view', function($container) use ($settings) {
    $view = Twig::create(__DIR__ . '/../resources/views', [
        'cache' => $settings['development_mode'] ? false: __DIR__ . '/../cache/twig'
    ]);

    $view->getEnvironment()->addGlobal('auth', $container->auth);

    if (!file_exists(__DIR__.'/../app/ember.lock')) {
        $container->instance('dbsettings', App\Models\Setting::allWithBG());
        $view->getEnvironment()->addGlobal('setting', $container->dbsettings->toArray());
        $view->getEnvironment()->addGlobal('navbarlink', App\Models\NavbarLink::orderBy('order','asc')->get()->toArray());
        $view->getEnvironment()->addGlobal('session', $_SESSION ?? null);
    }

    $mixFilter = new TwigFilter('mix', function ($string) {
        $manifest = json_decode(file_get_contents(__DIR__ . '/../public/mix-manifest.json'), true);
        return($manifest["/{$string}"]);
    });
    $view->getEnvironment()->addFilter($mixFilter);

    $view->getEnvironment()->addFilter(new TwigFilter('modulemix', function ($identifier, $asset) {
        $manifest = json_decode(file_get_contents(__DIR__ . "/../modules/$identifier/public/mix-manifest.json"), true);
        $script = str_replace('?', '&', $manifest["{$asset}"]);
        return("/modules/$identifier?f=" . $script);
    }));

    $view->getEnvironment()->addFilter(new TwigFilter('moduleasset', function ($identifier, $asset) use ($container) {
        return("/modules/$identifier?f=" . $asset . '&id=' . crc32($container->modules[$identifier]['version']));
    }));

    $view->getEnvironment()->addGlobal('script_version_hash', 'fb96ec514e2ff990f811102007456b92');

    $lang = $container->cache->get('lang');
    if ($lang == null && !file_exists(__DIR__.'/../app/ember.lock')) {
        $lang['active'] = $container->dbsettings['locale']['value'] ?? 'en';
        $lang['en'] = [];
        foreach (array_merge([__DIR__ . '/../resources/lang/en.php'], glob(__DIR__ . '/../modules/*/resources/lang/en.php')) as $langPath) {
            array_map(function($arr) use (&$lang) {
                foreach($arr as $key => $value) {
                    $lang['en'][$key] = $value;
                }
            }, include $langPath);
        }
        $translations = App\Models\Translation::where('locale', $lang['active']);
        $translationsArr = $translations->get()->pluck('value', 'key')->toArray();
        if ($lang['active'] == 'en') {
            $lang['en'] = array_merge($lang['en'], $translationsArr);
        } else {
            $lang = array_merge($lang, [$lang['active'] => $translationsArr]);
        }
        $lang['hash'] = crc32($translations->orderBy('updated_at', 'DESC')->first()->updated_at ?? null);
        $container->cache->put('lang', $lang);
    }
    $container->lang = $lang;
    $view->getEnvironment()->addGlobal('lang_hash', $lang['hash'] ?? 0);

    $langFilter = new TwigFilter('lang', function ($string, ...$s) use ($lang) {
        if (!empty($lang[$lang['active']][$string])) {
            $str = $lang[$lang['active']][$string];
        } else if (!empty($lang['en'][$string])) {
            $str = $lang['en'][$string];
        } else {
            $str = str_replace('_', ' ', ucfirst($string));
        }
        foreach ($s as $s)
            $str = preg_replace('/%s/', $s, $str, 1);
        return $str;
    });
    $view->getEnvironment()->addFilter($langFilter);

    return $view;
});

$app->add(new \App\Middleware\MigrationMiddleware($container));
$app->addRoutingMiddleware();
$app->add(TwigMiddleware::createFromContainer($app));

$errorMiddleware = $app->addErrorMiddleware($settings['development_mode'], true, true);
$errorMiddleware->setErrorHandler(\Slim\Exception\HttpNotFoundException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) {
    return $this->view->render($this->response->withStatus(404), 'error.twig', ['errorCode' => 404]);
});
$errorMiddleware->setErrorHandler(\Slim\Exception\HttpMethodNotAllowedException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) {
    return $this->view->render($this->response->withStatus(405), 'error.twig', ['errorCode' => 405]);
});
$errorMiddleware->setErrorHandler(\Slim\Exception\HttpUnauthorizedException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) {
    $response = $this->response->withStatus(401);
    if ($request->getHeader('Accept')[0] === 'application/json') {
        $response->getBody()->write(json_encode(['status' => 'unauthorized']));
        return $response->withHeader('Content-Type', 'application/json');
    } else {
        return $this->view->render($response, 'error.twig', ['errorCode' => 401]);
    }
});
$errorMiddleware->setErrorHandler(\Slim\Exception\HttpForbiddenException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) {
    $response = $this->response->withStatus(403);
    if ($request->getHeader('Accept')[0] === 'application/json') {
        $response->getBody()->write(json_encode(['status' => 'forbidden']));
        return $response->withHeader('Content-Type', 'application/json');
    } else {
        return $this->view->render($response, 'error.twig', ['errorCode' => 403]);
    }
});
$errorMiddleware->setErrorHandler(\Ahc\Jwt\JWTException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) use ($errorMiddleware) {
    return $this->view->render($this->response->withStatus(401), 'error.twig', ['errorCode' => 401, 'errorDetails' => $exception->getCode() == 52 ? 'Token expired.' : null]);
});
if (!$settings['development_mode']) {
    $errorMiddleware->setErrorHandler(\Slim\Exception\HttpInternalServerErrorException::class, function (Request $request, Throwable $exception, bool $displayErrorDetails) {
        return $this->view->render($this->response->withStatus(500), 'error.twig', ['errorCode' => 500]);
    });
    $errorMiddleware->setDefaultErrorHandler(function (Request $request, Throwable $exception, bool $displayErrorDetails) {
        return $this->view->render($this->response->withStatus(500), 'error.twig', ['errorCode' => 500]);
    });
}

$controllers = [
    'AdminController',
    'ApiController',
    'AuthController',
    'BanController',
    'FeatureController',
    'LoadingScreenController',
    'MigrationController',
    'NavbarLinkController',
    'NotificationController',
    'PagesController',
    'RoleController',
    'ServerApiController',
    'ServerController',
    'SettingController',
    'StoreController',
    'StorePackageController',
    'TeamController',
    'TranslationController',
    'UserController',
    'WebhookController'
];
foreach ($controllers as $c) {
    $cc = "\\App\\Controllers\\{$c}";
    $container[$c] = function($container) use ($cc) {
        return new $cc($container);
    };
}

$app->add(new \App\Middleware\TrailingSlashMiddleware($container));
$app->add(new \App\Middleware\LastOnlineMiddleware($container));

$dispatcher->listen(App\Events\StorePackagePurchaseCreated::class, App\Listeners\StorePackagePurchaseCreated::class);
$dispatcher->listen(App\Events\BanCreated::class, App\Listeners\BanCreated::class);
$dispatcher->listen(App\Events\SettingSaved::class, App\Listeners\SettingSaved::class);

require __DIR__ . '/../app/routes.php';
require __DIR__ . '/modules.php';
