<?php
use \App\Middleware\AuthMiddleware;
use \App\Middleware\GuestMiddleware;
use \App\Middleware\UserMatchMiddleware;
use \App\Middleware\UnlinkedMiddleware;
use \App\Middleware\CanBanMiddleware;
use \App\Middleware\AdminMiddleware;
use \App\Middleware\ServerTokenMiddleware;
use \App\Middleware\StorePurchaseMiddleware;

$app->get('/lang', 'TranslationController:lang');
$app->get('/modules/{identifier}', 'PagesController:moduleAsset');
$app->get('/dependencycheck', 'MigrationController:dependencycheck')->setName('dependencycheck');
$app->get('/migrate', 'MigrationController:migrate')->setName('migrate');

$app->get('/', 'PagesController:landing')->setName('landing');
$app->get('/tos', 'PagesController:tos')->setName('tos');
$app->get('/privacy', 'PagesController:privacy')->setName('privacy');
$app->get('/impressum', 'PagesController:impressum')->setName('impressum');
$app->get('/bans', 'PagesController:bans')->setName('bans');
$app->get('/users', 'PagesController:users')->setName('users');
$app->get('/loading/{id}', 'PagesController:loading')->setName('loading');
$app->get('/error/{code}', 'PagesController:error')->setName('error');

$app->get('/store/credits', 'StoreController:getCredits')->setName('store');
$app->get('/store/purchases', 'StoreController:getPurchases')->add(new AuthMiddleware($container))->setName('store_purchases');
$app->get('/store/servers', 'StoreController:servers')->setName('store_servers');
$app->get('/store/packages/{serverid}', 'StoreController:packages')->setName('store_packages');
$app->post('/store/packages/purchase/{id}', 'StoreController:purchasePackage');
$app->post('/store/sign', 'StoreController:postSign')->add(new StorePurchaseMiddleware($container))->add(new AuthMiddleware($container));

$app->get('/users/{id}', 'PagesController:user')->setName('user');
$app->get('/profile/{steamid}', 'PagesController:user')->setName('profile');
$app->get('/users/{id}/purchases', 'StoreController:getPurchases')->add(new AdminMiddleware($container))->add(new AuthMiddleware($container));
$app->get('/auth', 'AuthController:show')->add(new GuestMiddleware($container))->setName('auth');
$app->post('/auth/users/{id}/impersonate', 'AuthController:impersonate')->add(new AdminMiddleware($container));
$app->post('/auth/unimpersonate', 'AuthController:unimpersonate')->add(new AuthMiddleware($container))->setName('auth_unimpersonate');
$app->get('/auth/{provider}', 'AuthController:authenticate')->add(new UnlinkedMiddleware($container))->setName('auth_provider');
$app->post('/auth', 'AuthController:logout')->add(new AuthMiddleware($container))->setName('logout');

$app->get('/notifications', 'PagesController:notifications')->add(new AuthMiddleware($container))->setName('notifications');

$app->group('/admin/', function($group) {
    $group->get('store', 'AdminController:store')->setName('admin_store');
    $group->get('general', 'AdminController:general')->setName('admin_general');
    $group->get('bans', 'PagesController:bans')->setName('admin_bans');
    $group->get('users', 'PagesController:users')->setName('admin_users');
    $group->get('servers', 'AdminController:servers')->setName('admin_servers');
    $group->get('roles', 'AdminController:roles')->setName('admin_roles');
    $group->get('packages', 'PagesController:adminPackagesServerPicker')->setName('admin_packages');
    $group->get('packages/{server}', 'PagesController:adminPackages');
    $group->get('loadingscreens', 'AdminController:loadingScreens')->setName('admin_loading_screens');
    $group->get('landing', 'AdminController:landing')->setName('admin_landing');
    $group->get('localization', 'AdminController:localization')->setName('admin_localization');
})->add(new AdminMiddleware($container))->add(new AuthMiddleware($container));


$app->group('/api/', function($group) use ($container) {
    $group->post('users/{id}/roles', 'UserController:postRole');
    $group->delete('users/{id}/roles/{rid}', 'UserController:deleteRole');
    $group->put('users/{id}/credits', 'StoreController:updateCredits');
    $group->post('users/{id}/packages', 'StoreController:storePackage');
    $group->get('store/failedpaymentlogs', 'StoreController:getFailedPaymentLogs');
    $group->delete('cache', 'ApiController:deleteCache');
    
    $group->get('roles', 'RoleController:index');
    $group->post('roles', 'RoleController:store');
    $group->put('roles/{rid}', 'RoleController:update');
    $group->delete('roles/{rid}', 'RoleController:destroy');
    $group->post('roles/order', 'RoleController:reorder');
    $group->post('roles/{rid}/excludedservers/{server}', 'RoleController:storeExcludedServer');
    $group->delete('roles/{rid}/excludedservers/{server}', 'RoleController:destroyExcludedServer');
    $group->post('rolepermissions', 'RoleController:storePermission');
    $group->delete('rolepermissions', 'RoleController:destroyPermission');

    $group->get('storepackages', 'StorePackageController:index');
    $group->post('storepackages', 'StorePackageController:store');
    $group->put('storepackages/{id}', 'StorePackageController:update');
    $group->delete('storepackages/{id}', 'StorePackageController:destroy');
    $group->post('storepackages/order', 'StorePackageController:reorder');

    $group->post('servers', 'ServerController:store');
    $group->put('servers/{id}', 'ServerController:update');
    $group->delete('servers/{id}', 'ServerController:destroy');
    $group->post('servers/order', 'ServerController:reorder');
    $group->post('servers/{id}/rcon', 'ServerController:rcon');

    $group->group('features', function($group) use ($container) {
        $group->get('', 'FeatureController:index');
        $group->post('', 'FeatureController:store');
        $group->put('/{id}', 'FeatureController:update');
        $group->delete('/{id}', 'FeatureController:destroy');
        $group->post('/order', 'FeatureController:reorder');
    });

    $group->group('loadingscreens', function($group) use ($container) {
        $group->get('', 'LoadingScreenController:index');
        $group->post('', 'LoadingScreenController:store');
        $group->put('/{id}', 'LoadingScreenController:update');
        $group->delete('/{id}', 'LoadingScreenController:destroy');
    });

    $group->group('navbarlinks', function($group) use ($container) {
        $group->get('', 'NavbarLinkController:index');
        $group->post('', 'NavbarLinkController:store');
        $group->put('/{id}', 'NavbarLinkController:update');
        $group->delete('/{id}', 'NavbarLinkController:destroy');
        $group->post('/order', 'NavbarLinkController:reorder');
    });

    $group->group('teams', function($group) use ($container) {
        $group->get('', 'TeamController:index');
        $group->post('', 'TeamController:store');
        $group->put('/{id}', 'TeamController:update');
        $group->delete('/{id}', 'TeamController:destroy');
        $group->post('/order', 'TeamController:reorder');
    });

    $group->group('settings', function($group) use ($container) {
        $group->put('/{category}', 'SettingController:updateCategory');
    });

    $group->group('translations', function($group) use ($container) {
        $group->get('/{locale}', 'TranslationController:index');
        $group->put('/{locale}/{category}/{key}', 'TranslationController:update');
        $group->delete('/{locale}/{category}/{key}', 'TranslationController:destroy');
    });

    $group->group('webhooks', function ($group) {
        $group->get('', 'WebhookController:index');
        $group->post('', 'WebhookController:store');
        $group->put('/{id}', 'WebhookController:update');
        $group->delete('/{id}', 'WebhookController:destroy');
        $group->post('/order', 'WebhookController:reorder');
    });
})->add(new AdminMiddleware($container));

$app->group('/api/notifications', function($group) use ($container) {
    $group->get('', 'NotificationController:index');
    $group->post('/read', 'NotificationController:read');
})->add(new AuthMiddleware($container));

$app->group('/api/', function($group) use ($container) {
    $group->get('store/packagepurchases', 'StoreController:getPackagePurchases');
    $group->get('store/payments', 'StoreController:getPayments');
})->add(new AdminMiddleware($container));

$app->group('/api/users/{user_id}/', function ($group) {
    $group->get('packagepurchases', 'StoreController:getUserPackagePurchases');
    $group->get('payments', 'StoreController:getUserPayments');
})->add(new AuthMiddleware($container))->add(new UserMatchMiddleware($container));

$app->group('/api/bans', function($group) use ($container) {
    $group->post('', 'BanController:store');
    $group->post('/{id}/unban', 'BanController:unban');
    $group->delete('/{id}', 'BanController:destroy');
})->add(new CanBanMiddleware($container));

$app->group('/api/', function($group) use ($container) {
    $group->get('users', 'UserController:index');
    $group->get('servers', 'ServerController:index');
    $group->get('bans', 'BanController:index');
});

$app->group('/api/server/', function($group) {
    $group->get('connectioncheck', 'ServerApiController:getConnectionCheck');
    $group->post('users', 'ServerApiController:postUsers');
    $group->post('usersprocessed', 'ServerApiController:postUsersProcessed');
    $group->get('users/poll', 'ServerApiController:getUsersPoll');
    $group->post('users/{id}/bans', 'ServerApiController:postUserBan');
    $group->delete('users/{id}/bans', 'ServerApiController:deleteUserBan');
    $group->post('users/{id}/group', 'ServerApiController:postUserGroup');
    $group->post('users/{id}/roles', 'ServerApiController:postUserRole');
    $group->delete('users/{id}/roles/{ingame_equivalent}', 'ServerApiController:deleteUserRole');
    $group->post('users/{id}/link', 'ServerApiController:postUserLink');
})->add(new ServerTokenMiddleware($container));
