<?php
namespace App;

use Illuminate\Database\Capsule\Manager as DB;
use App\Models\StoreCredit;
use App\Models\StorePackage;
use App\Models\StorePackagePurchase;
use App\Models\StorePayment;
use App\Models\StoreFailedPaymentLog;
use App\Models\User;

class Store
{
    static function registerPaymentProcessor($array) {
        global $container;
        if(!$container->offsetExists('store'))
            $container->instance('store', []);
        
        $container->extend('store', function($store) use ($array) {
            $store[$array['identifier']] = $array;
            return $store;
        });
    }

    public static function purchaseLimitReached($user, $package) {
        return ($package->purchase_limit && $package->purchases()->where('user_id', $user->id)->count() >= $package->purchase_limit);
    }

    public static function grantPackage($package, $user, $payment) {
        $activePurchase = $package->valid_for ? $package->purchases()->where('user_id', $user->id)->valid()->first() : null;
        $expiry = $package->valid_for ? DB::raw("DATE_ADD(NOW(), INTERVAL '{$package->valid_for}' DAY)") : null;
        if ($activePurchase != null) {
            $expiry = DB::raw("DATE_ADD('{$activePurchase->expiry_timestamp}', INTERVAL '{$package->valid_for}' DAY)");
            $activePurchase->update(['expiry_timestamp' => DB::raw('NOW()')]);
        }
        StorePackagePurchase::create([
            'user_id' => $user->id,
            'package_id' => $package->id,
            'payment_id' => $payment->id ?? null,
            'package_name' => $package->name,
            'package_cost_credits' => $package->cost_credits,
            'expired' => $package->valid_for ? 0 : null,
            'expiry_timestamp' => $expiry
        ]);

        if ($package->rid)
            $user->addRole($package->rid);
    }

    public static function logFailedPayment($message, $processor, $processor_id, $response) {
        StoreFailedPaymentLog::create([
            'processor' => $processor,
            'processor_id' => $processor_id,
            'message' => $message
        ]);
        return $response->withStatus(200);
    }

    public static function handlePayment($data, $response) {
        if (StorePayment::where(['processor_id' => $data['processor_id'], 'processor' => $data['processor']])->exists())
            return;

        DB::transaction(function() use ($data) {
            $payment = StorePayment::create([
                'processor_id' => $data['processor_id'],
                'processor' => $data['processor'],
                'user_id' => $data['user_id'],
                'currency' => $data['currency'],
                'total' => $data['total']
            ]);

            if ($data['type'] === 'credits') {
                $creditsAmount = $data['quantity'];
                StoreCredit::updateOrCreate(['user_id' => $data['user_id']], ['credits' => DB::raw("credits + '${creditsAmount}'")]);
            } else if ($data['type'] === 'package') {
                $package = StorePackage::find($data['package_id']);
                $user = User::find($data['user_id']);
                self::grantPackage($package, $user, $payment);
            }
        });
    }
}
