<?php
namespace App\Models;

class UserRevokedRole extends Model
{
    public $timestamps = false;
    protected $guarded = [];
    protected $dispatchesEvents = [
        'created' => \App\Events\UserRevokedRoleCreated::class,
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function role() {
        return $this->hasOne('App\Models\Role', 'rid', 'rid');
    }
}
