<?php
namespace App\Models;

class StorePackagePurchase extends Model
{
    public $timestamps = false;
    protected $guarded = [];
    protected $dispatchesEvents = [
        'saving' => \App\Events\StorePackagePurchaseSaving::class,
        'created' => \App\Events\StorePackagePurchaseCreated::class
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function storePackage() {
        return $this->hasOne(StorePackage::class, 'id', 'package_id');
    }

    public function storePayment() {
        return $this->hasOne(StorePayment::class, 'id', 'payment_id');
    }

    public function scopeExpiring($query) {
        return $query->where('redeemed', 1)->where('expired', 0)->whereRaw('expiry_timestamp <= NOW()');
    }

    public function scopeValid($query) {
        $query->where(function ($q) {
            $q->where('expired', 0)->whereRaw('expiry_timestamp > NOW()');
        })->orWhere('expired', null);
    }

    public function scopeUnredeemed($query) {
        return $query->where('redeemed', 0);
    }

    public function getPackageAttribute() {
        return $this->storePackage;
    }
}
