<?php
namespace App\Models;

class Ban extends Model
{
    public $timestamps = false;
    protected $guarded = [];
    protected $dispatchesEvents = [
        'created' => \App\Events\BanCreated::class
    ];

    public function server() {
        return $this->belongsTo(Server::class);
    }

    public function offender() {
        return $this->hasOne(User::class, 'id', 'offender_user_id');
    }

    public function admin() {
        return $this->hasOne(User::class, 'id', 'admin_user_id');
    }
}
