<?php
namespace App\Middleware;

use Slim\Routing\RouteContext;

class UnlinkedMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        $routeContext = RouteContext::fromRequest($request);
        $args = RouteContext::fromRequest($request)->getRoutingResults()->getRouteArguments();

        if ($this->container->auth->check() && $this->container->auth->user()[$args['provider'] . 'id'] != null)
            return $this->container->response->withHeader('Location', $routeContext->getRouteParser()->urlFor('user', ['id' => $this->container->auth->id()]))->withStatus(302);

        return $handler->handle($request);
    }
}
