<?php
namespace App\Middleware;

use \Slim\Routing\RouteContext;

class AuthMiddleware extends Middleware
{
    public function __invoke($request, $handler) {
        if (!$this->container->auth->check()) {
            if ($request->getMethod() === 'GET') {
                $routeParser = RouteContext::fromRequest($request)->getRouteParser();
                return $this->container->response->withHeader('Location', $routeParser->urlFor('auth', [], ['redirect' => $request->getUri()->getPath()]))->withStatus(302);
            } else {
                throw new \Slim\Exception\HttpUnauthorizedException($request);
            }
        }

        return $handler->handle($request);
    }
}
