<?php
namespace App;

use App\Models\Setting;
use Ahc\Jwt\JWT;

class Helpers
{
    static function verStrToInt($ver) {
        $verArr = explode('.',$ver);
        $verStr = ''; foreach ($verArr as $k=>$ver) { $verStr = $verStr.sprintf("%02d", $ver); }
        $ver = (int)$verStr;
        return $ver;
    }

    static function removeRecursively($dir) {
        if (file_exists($dir)) {
            foreach(new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($dir, \FilesystemIterator::SKIP_DOTS), \RecursiveIteratorIterator::CHILD_FIRST) as $path) {
                $pN = $path->getPathname(); !$path->isDir() || $path->isLink() ? unlink($pN) : rmdir($pN);
            }
        }
    }

    static function whitelist_keys(array $array, array $wlKeys) {
        $filteredNested = []; // temp array for multidimensional arrays

        $array = array_filter(
            $array,
            function ($v,$k) use ($wlKeys, &$filteredNested, $array) {
              if (is_array($v) && !in_array($k, $wlKeys)) { // handle multidimensional keys
                  if (is_numeric($k) && in_array('*', array_keys($wlKeys))) { // handle wildcard for multiple nested arrays on the same level
                    foreach ($array as $elK=>$el) { // iterate over all arrays on this level using the same filter rules
                        $filteredNested[$elK] = Helpers::whitelist_keys($el, $wlKeys['*']);
                    }
                  } else if (isset($wlKeys[$k])) {
                      $filteredNested[$k] = Helpers::whitelist_keys($v, $wlKeys[$k]);
                  }
                  return false;
              } else {
                return in_array($k, $wlKeys); // include value if its key is part of the whitelist
              }
            },
            ARRAY_FILTER_USE_BOTH
        );

        foreach ($filteredNested as $k=>$v) {
            $array[$k] = $v;
        }

        return $array;
    }

    static function jwt() {
        $secret = Setting::firstOrCreate([
          'setting' => 'jwt_secret',
          'category' => 'general'
        ], [
          'value' => bin2hex(random_bytes(256)) // generate a secret if it doesn't exist
        ])->value;
        return new JWT($secret);
    }

    /**
     * Gets the names of all classes that extend \App\Models\BaseModel.
     * 
     * @return array
     */
    static function getModelClasses() {
        global $loader;

        // Get namespace directories from Composer ClassLoader.
        $reflectionProperty = new \ReflectionProperty($loader, 'prefixDirsPsr4');
        $reflectionProperty->setAccessible(true);
        $namespaceDirs = $reflectionProperty->getValue($loader);

        // Only include module namespaces.
        $moduleNamespaceDirs = array_filter($namespaceDirs, function ($dir) {
            return strpos($dir[0], '/bootstrap/../modules');
        });

        /**
         * Generate class names based on namespace and files in directory.
         * 
         * @return array
         */
        function getClasses($namespace, $dir) {
            if (!is_dir($dir)) return [];

            return array_map(function ($filename) use ($namespace) {
                return $namespace . '\\' . str_replace('.php', '', $filename);
            }, scandir($dir));
        }

        $modelClasses = getClasses('App\Models', __DIR__ . '/Models'); // core model classes
        foreach ($moduleNamespaceDirs as $namespace => $dir) {
            $namespace = substr($namespace, 0, -1); // remove trailing backslash
            $modelClasses = array_merge($modelClasses, getClasses("$namespace\Models", $dir[0] . '/Models'));
        }

        $modelClasses = array_values(array_filter($modelClasses, function ($class) {
            return class_exists($class) && is_subclass_of($class, \App\Models\BaseModel::class) && $class !== \App\Models\Model::class;
        }));

        return $modelClasses;
    }
}
