<?php
namespace App\Controllers;

use App\Controllers\Controller;

class ApiResourceController extends Controller
{
    protected $model;
    protected $columns;

    public function index($request, $response, $args) {
        return $response->withJSON(['data' => $this->model::orderBy('order', 'asc')->get()]);
    }

    public function store($request, $response, $args) {
        $data = $this->model::create($this->columnValues($request));
        return $response->withJSON(['data' => $data]);
    }

    public function update($request, $response, $args) {
        $this->model::updateOrCreate([(new $this->model)->getKeyName() => $args['id']], $this->columnValues($request));
        return $response->withStatus(204);
    }

    public function destroy($request, $response, $args) {
        $this->model::destroy($args['id']);
        return $response->withStatus(204);
    }

    public function reorder($request, $response, $args) {
        foreach ($request->getParam('order') as $id => $order) {
            $this->model::find($id)->update(['order' => $order]);
        }
        return $response->withStatus(204);
    }

    protected function columnValues($request) {
        $values = [];
        foreach ($this->columns as $column) {
            $value = $request->getParam($column);
            $values[$column] = empty($value) ? null : $value;
        }
        return $values;
    }
}
