<?php
namespace App\Auth;

use App\Models\User;

class Auth
{
    public function user() {
        if ($this->check())
            return User::find($this->id());
    }

    public function check() {
        return $this->id() !== null;
    }

    public function id() {
        return $_SESSION['user_id'] ?? null;
    }

    public function setId($id) {
        $_SESSION['user_id'] = $id;
    }

    public function isImpersonator() {
        return isset($_SESSION['impersonator_user_id']);
    }

    public function impersonateId($id) {
        if ($this->isImpersonator()) return;
        $_SESSION['impersonator_user_id'] = $this->id();
        $this->setId($id);
    }

    public function unimpersonate() {
        if (!$this->isImpersonator()) return;
        $this->setId($_SESSION['impersonator_user_id']);
        unset($_SESSION['impersonator_user_id']);
    }

    public function consumeRedirectUrl() {
        $url = $_SESSION['auth_redirect'] ?? null;
        unset($_SESSION['auth_redirect']);
        return $url;
    }

    public function setRedirectUrl($url) {
        $_SESSION['auth_redirect'] = $url;
    }

    public function isOwner() {
        return ($this->check() && $this->user()->steamid === '76561197960275975');
    }

    public function isBanned() {
        if (!$this->check())
            return false;
        return $this->user()->isBannedFromWeb();
    }

    public function isAdmin() {
        if ($this->isOwner()) {
            return true;
        } else if ($this->check()) {
            return $this->user()->hasPermission('admin');
        } else {
          return false;
        }
    }

    public function canBan() {
        if ($this->isAdmin()) {
            return true;
        } else if ($this->check()) {
            return $this->user()->hasPermission('manage_bans');
        } else {
          return false;
        }
    }
}
