ember = {}
ember.userData = {}
ember.usersToPost = {}
ember.usersProcessed = {}
ember.groupSync = {}
ember.bans = {}
ember.package = {}
ember.exp_package = {}
ember.perma_weapons = {}
include("ember_config.lua")
ember.API = string.TrimRight(ember.Host, "/") .. "/api/server/"

ember.print = function(msg)
	print(os.date("%H:%M:%S", os.time()).." - [Ember] "..msg)
end

ember.httpError = function(error)
	ember.print("Web request failed")
	ember.print("Error details: "..error)
end

ember.Fetch = function(url, onSuccess)
	http.Fetch(ember.API .. url, onSuccess, ember.httpError, { Authorization = "Bearer " .. ember.Token, Accept = "application/json" })
end

ember.Post = function(url, parameters, onSuccess)
	http.Post(ember.API .. url, parameters, onSuccess, ember.httpError, { Authorization = "Bearer " .. ember.Token, Accept = "application/json" })
end

ember.Delete = function(url, onSuccess)
	HTTP({ url = ember.API .. url, method = "DELETE", parameters = parameters, success = function(code, body) onSuccess(body) end, failed = ember.httpError, headers = { Authorization = "Bearer " .. ember.Token, Accept = "application/json" } })
end

hook.Add("InitPostEntity", "ember_connection_check", function()
	timer.Simple(0.1, function() -- this is to avoid "ISteamHTTP isn't available!" on server startup
		ember.print("Checking connection to server")
		ember.Fetch("connectioncheck", function(body)
			res = util.JSONToTable(body)
			if (type(res) == 'table' && res['status'] == 'success') then
				ember.groupSync.receive = res['settings']['role_sync']['receive']
				ember.groupSync.send = res['settings']['role_sync']['send']

				if (res['settings']['ban_log']) then
					ember.AddBanHooks()
				end

				if res['settings']['poll_interval'] > 0 then
					timer.Create("ember_poll_timer", res['settings']['poll_interval'], 0, ember.poll)
				end

				ember.print("Connection established and token validated successfully")
			else
				ember.print("Request failed. Response: "..body)
			end
		end)
	end)
end)

function ember.postUsers(users)
	if table.Count(users) == 0 then return end

	ember.print("Posting " .. table.Count(users) .. " user(s)")
	local names = ''
	for _, name in pairs(users) do
		names = names .. string.Replace(name, ',', '') .. ','
	end
	ember.Post("users", { steamids = table.concat(table.GetKeys(users), ','), names = names }, function(body)
		local res = util.JSONToTable(body)
		if (type(res) == 'table' && res['users'] != nil) then
			for _, user in pairs(res['users']) do
				if (user['banned'] == true) then
					game.KickID(util.SteamIDFrom64(user['steamid']), 'You have been banned from the server. Check our website at '..ember.Host..' to see when your ban expires')
				else
					ember.userData[user["steamid"]] = user -- used by store.lua
					local ply = player.GetBySteamID64(user["steamid"])
					if ply != false then ember.handleUserDetails(ply) end
				end
			end
		else
			ember.print("Request failed. Response: "..body)
		end
	end)
end

function ember.postUsersProcessed(users)
	if #users == 0 then return end
	ember.Post("usersprocessed", { steamids = table.concat(users, ',') })
end

timer.Create("ember_post_users_timer", 5, 0, function()
	ember.postUsersProcessed(ember.usersProcessed)
	ember.usersProcessed = {}
	ember.postUsers(ember.usersToPost)
	ember.usersToPost = {}
end)

hook.Add("CheckPassword", "ember_handleConnectingUser", function(steamID64, ipAddress, svPassword, clPassword, name)
	ember.usersToPost[steamID64] = name
end)

hook.Add("CAMI.PlayerUsergroupChanged", "ember_user_group_change_sync", function(ply, old, new, source)
	if (ember.groupSync.send && source != "Ember") then
		ember.Post("users/"..ply:SteamID64().."/group", { group=new }, function(body)
			local res = util.JSONToTable(body)
			if (type(res) == 'table' && res['status'] == 'success') then
				ember.print('Synchronized group change for '..ply:Nick()..' ('..ply:SteamID64()..')')
			else
				ember.print("Request failed. Response: "..body)
			end
		end)
	end
end)

concommand.Add("ember_sync", function (ply)
	ply:ChatPrint("Synchronizing groups & purchases")
	ember.usersToPost[ply:SteamID64()] = ply:Name()
end)


function ember.poll()
	local steamids = {}
	for _, ply in pairs(player.GetAll()) do
		local steamID64 = ply:SteamID64()
		if ember.usersToPost[steamID64] != nil and not table.HasValue(ember.usersProcessed, steamID64) then
			table.insert(steamids, steamID64)
		end
	end
	if not table.IsEmpty(steamids) then
		ember.Fetch("users/poll?steamids=" .. table.concat(steamids, ','), function(body)
			local res = util.JSONToTable(body)
			if (type(res) == 'table' && res['status'] == 'success') then
				for _, steamID64 in pairs(res['users']) do
					ember.usersToPost[steamID64] = ''
				end
			else
				ember.print("Request failed. Response: "..body)
			end
		end)
	end
end

function ember.setUserGroup(ply, group)
	if (CAMI.GetUsergroup(group) == nil) then
		CAMI.RegisterUsergroup({ ["Name"] = group, ["Inherits"] = "user" }, "Ember")
	end
	CAMI.SignalUserGroupChanged(ply, "", group, "Ember")
	ember.print("Updated the group for "..ply:Nick().."("..ply:SteamID64()..") to "..group..".")
end

function ember.setUserGroupBySteamID(steamID64, group, name)
	name = name or "user"
	if (CAMI.GetUsergroup(group) == nil) then
		CAMI.RegisterUsergroup({ ["Name"] = group, ["Inherits"] = "user" }, "Ember")
	end
	CAMI.SignalSteamIDUserGroupChanged(util.SteamIDFrom64(steamID64), "", group, "Ember")
	ember.print("Updated the group for "..name.." ("..steamID64..") to "..group..".")
end

concommand.Add("ember_setusergroup", function (ply, cmd, args) -- ember_setusergroup <steamid> <group>
	if ply:IsPlayer() then return end
	ember.setUserGroupBySteamID(args[1], args[2])
end)

include("ember/store.lua")
include("ember/bans.lua")
