CAMI.RegisterPrivilege({["Name"] = "ember_ban", ["MinAccess"] = "superadmin"})
CAMI.RegisterPrivilege({["Name"] = "ember_unban", ["MinAccess"] = "superadmin"})

ember.Ban = function (offenderSteamid, expiryMinutes, reason, global, adminSteamid, caller)
  local expiry_minutes = tostring(math.Round(tonumber(expiryMinutes)))
  local g = global; if (g == true) then g = tostring(g) end -- send the 'global' parameter if an only if it's true
  ember.Post("users/"..offenderSteamid.."/bans", {global = g, reason = reason, admin_steamid = adminSteamid, expiry_minutes = expiry_minutes}, function(body)
		local res = util.JSONToTable(body)
		if (type(res) == 'table' && res['status'] == 'success') then
			ember.print('Ban sent to server successfully')
			if caller != nil and caller:IsValid() then
				caller:ChatPrint("[Ember] player banned")
			end
			return true
		else
			ember.print("Request failed. Response: "..body)
			if caller != nil and caller:IsValid() then
				caller:ChatPrint("[Ember] failed to ban player")
			end
			return false
		end
    end)
end

ember.Unban = function (offenderSteamid, caller)
	ember.Delete("users/"..offenderSteamid.."/bans", function(body)
		local res = util.JSONToTable(body)
		if (type(res) == 'table' && res['status'] == 'success') then
			ember.print('Unbanned '..offenderSteamid)
			if caller != nil and caller:IsValid() then
				caller:ChatPrint("[Ember] player unbanned")
			end
			return true
		else
			ember.print("Request failed. Response: "..body)
			if caller != nil and caller:IsValid() then
				caller:ChatPrint("[Ember] failed to unban player")
			end
			return false
		end
    end)
end

local function findPly (target)
	name = string.lower(target)
	for _,v in ipairs(player.GetHumans()) do
		if(string.find(string.lower(v:Name()), name, 1, true) != nil) then
			return v
		end
	end
end

concommand.Add("ember_ban", function (ply, cmd, args) -- ember_ban <steamid/name> <time (minutes)> <reason> <local/global>
	local admin_steamid = nil

	if ply != nil and ply:IsValid() then
		CAMI.PlayerHasAccess(ply, "ember_ban", function(b, _)
			if (not b && !ply:IsSuperAdmin()) then ply:ChatPrint("[Ember] insufficient permissions"); return end
			ply:ChatPrint("[Ember] banning player..")
			admin_steamid = ply:SteamID64()
		end)
	end
	
	local offender_steamid = nil
	local offender_str = args[1]
	local foundPly = findPly (offender_str)
	if (foundPly != nil) then
		offender_steamid = foundPly:SteamID64()
	elseif (string.StartWith( offender_str, "7656119" ) == true) then
		offender_steamid = offender_str
	else return end -- offender_steamid not found/valid
	local time = args[2]
	local reason = args[3]
	local global = args[4]

	ember.Ban (offender_steamid, time, reason, global, admin_steamid, ply)
	game.KickID(util.SteamIDFrom64(offender_steamid), 'You have been banned with the reason "'..(reason or '')..'". Check our website to see when your ban expires')
end)

concommand.Add("ember_kick", function (ply, cmd, args) -- ember_kick <steamid> <reason>
	if ply:IsPlayer() then return end
	ember.print('Kicking ' .. args[1])
	game.KickID(util.SteamIDFrom64(args[1]), (args[2] or ''))
end)

concommand.Add("ember_unban", function (ply, cmd, args) -- ember_unban <steamid>
	if ply != nil and ply:IsValid() then
		CAMI.PlayerHasAccess(ply, "ember_unban", function(b, _)
			if (not b && !ply:IsSuperAdmin()) then ply:ChatPrint("[Ember] insufficient permissions"); return end
		end)
	end
	if (string.StartWith(args[1], "7656119" ) == true) then
		ply:ChatPrint("[Ember] unbanning player..")
		ember.Unban(args[1], ply)
	else
		ply:ChatPrint("[Ember] invalid SteamID")
	end
end)

ember.AddBanHooks = function()
	if (ember.bans.ulib_ban == true) then
		hook.Add("ULibPlayerBanned", "ember_ulib_ban", function (steamid, ban_data)
			ember.print("logging ULib ban")
			local offender_steamid = util.SteamIDTo64(steamid)
			local admin_steamid = nil
			if (ban_data.admin != nil) then
				admin_steamid = util.SteamIDTo64(string.gsub(string.gsub(ban_data.admin, "(.*)%(", ""), "%)", "")) -- thanks for the formatting, ULib
				if (admin_steamid == '0') then
					admin_steamid = nil
				end
			end
			local time = (ban_data.unban-os.time())/60 -- ban time in minutes
			ember.Ban(offender_steamid, time, ban_data.reason, false, admin_steamid)
		end)
	end

	if (ember.bans.ulib_unban == true) then
		hook.Add("ULibPlayerUnBanned", "ember_ulib_unban", function(steamid)
			ember.print("logging ULib unban")
			ember.Unban(util.SteamIDTo64(steamid))
		end)
	end

	if (ember.bans.sam_ban == true) then
		local sam_ban = function(steamid, unban_date, reason, admin_steamid)
			ember.print("logging SAM ban")
			if (admin_steamid == 'Console') then
				admin_steamid = nil
			else
				admin_steamid = util.SteamIDTo64(admin_steamid)
			end
			local time = (unban_date-os.time())/60 -- ban time in minutes
			ember.Ban(util.SteamIDTo64(steamid), time, reason, false, admin_steamid)
		end
		hook.Add("SAM.BannedSteamID", "ember_sam_ban_steamid", sam_ban)
		hook.Add("SAM.BannedPlayer", "ember_sam_ban_player", function(ply, unban_date, reason, admin_steamid)
			sam_ban(ply:SteamID(), unban_date, reason, admin_steamid)
		end)
	end

	if (ember.bans.sam_unban == true) then
		hook.Add("SAM.UnbannedSteamID", "ember_sam_unban", function(steamid, admin)
			ember.print("logging SAM unban")
			ember.Unban(util.SteamIDTo64(steamid))
		end)
	end
end
