ember = {}
ember.banvgui = {}

local function createBanFrame()
  local banSteamID = player.GetHumans()[1]:SteamID64()
  local banTime = 0
  local banReason = nil
  local globalBan = nil

  local banFrame = vgui.Create("DFrame")
  banFrame:SetSize(ScrW() * 400/1920, ScrH() * 190/1200)
  banFrame:Center()
  banFrame:SetTitle("Ember ban")
  banFrame:SetVisible(true)
  banFrame:SetDraggable(false)
  banFrame:ShowCloseButton(true)
  banFrame:MakePopup()

  local plyNameL = vgui.Create( "DLabel", banFrame )
  plyNameL:SetPos(ScrW() * 20/1920, ScrH() * 40/1200)
  plyNameL:SetText("Player:")

  ember.banvgui.plyNameTE = vgui.Create("DTextEntry", banFrame)
  ember.banvgui.plyNameTE:SetPos(ScrW() * 60/1920, ScrH() * 40/1200)
  ember.banvgui.plyNameTE:SetSize(ScrW() * 300/1920, ScrH() * 20/1200)
  ember.banvgui.plyNameTE:SetText(player.GetHumans()[1]:Name())
  ember.banvgui.plyNameTE.OnChange = function(self)
    print("entered")
    ember.banvgui.plyCB:SetValue("")
    banSteamID = self:GetValue()
  end

  ember.banvgui.plyCB = vgui.Create("DComboBox", banFrame)
  ember.banvgui.plyCB:SetPos(ScrW() * 360/1920, ScrH() * 40/1200)
  ember.banvgui.plyCB:SetSize(ScrW() * 20/1920, ScrH() * 20/1200)
  for k,v in pairs(player.GetHumans()) do
    ember.banvgui.plyCB:AddChoice(v:Name(),v:SteamID64())
  end
  ember.banvgui.plyCB:SetValue("")
  function ember.banvgui.plyCB:OnSelect(index, value, data)
  	print( value .. " " ..  data .." was selected!" )
    ember.banvgui.plyNameTE:SetText(value)
    banSteamID = data
    self:SetValue("")
  end

  local banReasonL = vgui.Create( "DLabel", banFrame )
  banReasonL:SetPos(ScrW() * 20/1920, ScrH() * 70/1200)
  banReasonL:SetSize(ScrW() * 200/1920, ScrH() * 20/1200)
  banReasonL:SetText("Reason:")

  local banReasonTE = vgui.Create("DTextEntry", banFrame)
  banReasonTE:SetPos(ScrW() * 60/1920, ScrH() * 70/1200)
  banReasonTE:SetSize(ScrW() * 320/1920, ScrH() * 20/1200)
  banReasonTE:SetText("")
  banReasonTE.OnChange = function(self)
    banReason = self:GetValue()
  end

  local banTimeL = vgui.Create( "DLabel", banFrame )
  banTimeL:SetPos(ScrW() * 20/1920, ScrH() * 102.5/1200)
  banTimeL:SetText("Ban length (minutes, 0 for permanent):")
  banTimeL:SizeToContents()

  local banTimeTE = vgui.Create("DTextEntry", banFrame)
  banTimeTE:SetPos(ScrW() * 210/1920, ScrH() * 100/1200)
  banTimeTE:SetSize(ScrW() * 40/1920, ScrH() * 20/1200)
  banTimeTE:SetText("0")
  banTimeTE.OnChange = function(self)
    banTime = tonumber(self:GetValue()) or banTime
  end

  local globalBanCB = vgui.Create("DCheckBoxLabel", banFrame)
  globalBanCB:SetPos(ScrW() * 260/1920, ScrH() * 102.5/1200)
  globalBanCB:SetText("Global ban")
  globalBanCB.OnChange = function (val)
  	if val then globalBan = " true" else globalBan = nil end
  end
  globalBanCB:SizeToContents()

  local ConfirmBan = vgui.Create("DButton", banFrame)
  ConfirmBan:SetText("Ban")
  ConfirmBan:SetPos(ScrW() * 160/1920, ScrH() * 135/1200)
  ConfirmBan:SetSize(ScrW() * 80/1920, ScrH() * 35/1200)
  ConfirmBan.DoClick = function()
    RunConsoleCommand("ember_ban", banSteamID, banTime, banReason, globalBan)
    banFrame:Close()
  end
end

hook.Add("OnPlayerChat", "ember_ban_chat_command", function (ply, text)
  if (ply != LocalPlayer()) then return end
  if (string.sub(text, 1, 5) == "#ban ") then
    ply:ConCommand("ember_ban "..string.gsub(text, "#ban ", ""))
    return true
  elseif (string.sub(text, 1, 4) == "#ban") then
    if (LocalPlayer():IsSuperAdmin()) then
      createBanFrame()
    else
      CAMI.PlayerHasAccess(LocalPlayer(), "ember_ban", function(b, _)
        if not b then LocalPlayer():ChatPrint("[Ember] insufficient permissions"); return end
        createBanFrame()
      end)
    end
    return true
  end
end)

hook.Add("OnPlayerChat", "ember_unban_chat_command", function (ply, text)
  if (ply != LocalPlayer()) then return end
  if (string.sub(text, 1, 6) == "#unban") then
    ply:ConCommand("ember_unban "..string.gsub(text, "#unban ", ""))
    return true
  end
end)

hook.Add("OnPlayerChat", "ember_sync_chat_command", function (ply, text)
  if (ply != LocalPlayer()) then return end
  if (string.sub(text, 1, 5) == "/sync") then
    ply:ConCommand("ember_sync")
    return true
  end
end)